/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server.chat;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.exceptions.IncompatibleServerException;
import io.github.rothes.protocolstringreplacer.nms.NmsManager;
import io.github.rothes.protocolstringreplacer.nms.packetreader.ChatType;
import io.github.rothes.protocolstringreplacer.util.SpigotUtils;
import java.lang.reflect.Field;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;

public class PlayerChatHelper {
    public static Version version;
    private static Class<?> chatSenderClass;
    private static Class<?> playerChatMessageClass;
    private static Class<?> messageBodyClass;
    private static Class<?> messageBodySubClass;
    private static Class<?> chatMessageTypeSubClass;
    private static Field chatMessageField;
    private static Field messageBodyField;
    private static Field messageContentField;
    private static Field messageStringField;
    private static Field playerChatMessageComponentField;
    private static Field stringField;
    private static Field componentField;
    private static Field displayNameField;
    private static Field teamNameField;
    private static Field chatTypeField;

    private static void setupNameFields(Class<?> clazz) {
        Class componentClass = MinecraftReflection.getIChatBaseComponentClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() == componentClass) {
                if (displayNameField == null) {
                    displayNameField = field;
                    field.setAccessible(true);
                    continue;
                }
                if (teamNameField == null) {
                    teamNameField = field;
                    field.setAccessible(true);
                    continue;
                }
                ProtocolStringReplacer.warn("There may be errors hooking into ChatSender, which may lead to PlayerChat convert problems.");
                continue;
            }
            if (field.getType() != Integer.TYPE) continue;
            chatTypeField = field;
            chatTypeField.setAccessible(true);
        }
    }

    public static boolean isLegacy() {
        return chatSenderClass != null;
    }

    public static Object getChatSender(StructureModifier<Object> modifier) {
        return modifier.withType(PlayerChatHelper.getChatSenderClass()).read(0);
    }

    public static Class<?> getPlayerChatMessageClass() {
        return playerChatMessageClass;
    }

    public static Class<?> getMessageBodySubClass() {
        return messageBodySubClass;
    }

    public static Object getComponentHolder(Object playerChatMessage) {
        try {
            return messageContentField.get(messageBodyField.get(playerChatMessage));
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static WrappedChatComponent getOptionalChatMessage(Object playerChatMessage) {
        try {
            return WrappedChatComponent.fromHandle(((Optional)playerChatMessageComponentField.get(playerChatMessage)).get());
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static WrappedChatComponent getChatMessage(Object playerChatMessage) {
        try {
            return WrappedChatComponent.fromHandle((Object)componentField.get(messageContentField.get(messageBodyField.get(playerChatMessage))));
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static WrappedChatComponent getChatMessageR3(Object messageBody) {
        try {
            return WrappedChatComponent.fromLegacyText((String)((String)messageStringField.get(messageBody)));
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static WrappedChatComponent getChatMessageByHolder(Object componentHolder) {
        try {
            return WrappedChatComponent.fromHandle((Object)componentField.get(componentHolder));
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static void setChatMessage(Object playerChatMessage, WrappedChatComponent wrappedChatComponent) {
        try {
            componentField.set(messageContentField.get(messageBodyField.get(playerChatMessage)), wrappedChatComponent.getHandle());
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static void setChatMessageByHolder(Object componentHolder, WrappedChatComponent wrappedChatComponent) {
        try {
            componentField.set(componentHolder, wrappedChatComponent.getHandle());
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static Object getChatMessageTypeSub(StructureModifier<Object> modifier) {
        return modifier.withType(PlayerChatHelper.getChatMessageTypeSubClass()).read(0);
    }

    public static int getChatTypeId(Object object) {
        try {
            return (Integer)chatTypeField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static BaseComponent getDisplayName(Object object) {
        return SpigotUtils.parseComponents(PlayerChatHelper.getDisplayNameWrapped(object).getJson())[0];
    }

    public static WrappedChatComponent getDisplayNameWrapped(Object object) {
        try {
            Object o = displayNameField.get(object);
            if (o == null) {
                return null;
            }
            return WrappedChatComponent.fromHandle((Object)o);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static void setDisplayName(Object object, WrappedChatComponent wrappedChatComponent) {
        try {
            displayNameField.set(object, wrappedChatComponent);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static BaseComponent getTeamName(Object object) {
        return SpigotUtils.parseComponents(PlayerChatHelper.getTeamNameWrapped(object).getJson())[0];
    }

    public static WrappedChatComponent getTeamNameWrapped(Object object) {
        try {
            Object o = teamNameField.get(object);
            if (o == null) {
                return null;
            }
            return WrappedChatComponent.fromHandle((Object)o);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static void setTeamName(Object object, WrappedChatComponent wrappedChatComponent) {
        try {
            teamNameField.set(object, wrappedChatComponent);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
    }

    public static Class<?> getChatSenderClass() {
        return chatSenderClass;
    }

    public static Class<?> getChatMessageTypeSubClass() {
        return chatMessageTypeSubClass;
    }

    public static ChatType getChatType(ClientboundPlayerChatPacket packet) {
        return NmsManager.INSTANCE.getPacketReader().readChatType(packet);
    }

    static {
        byte serverMajorVersion = ProtocolStringReplacer.getInstance().getServerMajorVersion();
        byte serverMinorVersion = ProtocolStringReplacer.getInstance().getServerMinorVersion();
        if (serverMajorVersion <= 18) {
            version = Version.V8_0_TO_V18_2;
        } else {
            version = serverMajorVersion == 19 ? (serverMinorVersion == 0 ? Version.V19_0 : (serverMinorVersion <= 2 ? Version.V19_1_TO_V19_2 : (serverMinorVersion == 3 ? Version.V19_3 : Version.V19_4))) : Version.V19_4;
            NmsManager.INSTANCE.getPacketReader();
        }
        if (version != Version.V8_0_TO_V18_2) {
            try {
                messageBodyClass = MinecraftReflection.getMinecraftClass((String)"network.chat.SignedMessageBody");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                playerChatMessageClass = MinecraftReflection.getMinecraftClass((String)"network.chat.PlayerChatMessage");
                for (Field declaredField : playerChatMessageClass.getDeclaredFields()) {
                    if (declaredField.getType() != Optional.class) continue;
                    declaredField.setAccessible(true);
                    playerChatMessageComponentField = declaredField;
                    break;
                }
                Class<ChatMessageType> chatMessageTypeClass = ChatMessageType.class;
                block5: for (Field field : PacketType.Play.Server.CHAT.getPacketClass().getDeclaredFields()) {
                    Class<?> declaringClass = field.getType().getDeclaringClass();
                    if (declaringClass == chatMessageTypeClass) {
                        chatMessageTypeSubClass = field.getType();
                        PlayerChatHelper.setupNameFields(chatMessageTypeSubClass);
                        continue;
                    }
                    if (messageBodyClass != null && declaringClass == messageBodyClass) {
                        messageBodySubClass = field.getType();
                        for (Field declaredField : messageBodySubClass.getDeclaredFields()) {
                            if (declaredField.getType() != String.class) continue;
                            messageStringField = declaredField;
                            messageStringField.setAccessible(true);
                            continue block5;
                        }
                        continue;
                    }
                    if (field.getType() != playerChatMessageClass) continue;
                    chatMessageField = field;
                    chatMessageField.setAccessible(true);
                    for (Field declaredField : playerChatMessageClass.getDeclaredFields()) {
                        if (declaredField.getType() != messageBodyClass) continue;
                        messageBodyField = declaredField;
                        messageBodyField.setAccessible(true);
                        Class messageContentClass = MinecraftReflection.getMinecraftClass((String)"network.chat.ChatMessageContent");
                        for (Field messageContentClassDeclaredField : messageBodyClass.getDeclaredFields()) {
                            if (messageContentClassDeclaredField.getType() != messageContentClass) continue;
                            messageContentField = messageContentClassDeclaredField;
                            messageContentField.setAccessible(true);
                            for (Field contentClassDeclaredField : messageContentClass.getDeclaredFields()) {
                                if (contentClassDeclaredField.getType() == String.class) {
                                    stringField = contentClassDeclaredField;
                                    stringField.setAccessible(true);
                                    continue;
                                }
                                if (contentClassDeclaredField.getType() != MinecraftReflection.getIChatBaseComponentClass()) continue;
                                componentField = contentClassDeclaredField;
                                componentField.setAccessible(true);
                            }
                        }
                    }
                }
                if (chatMessageTypeSubClass == null) {
                    chatSenderClass = MinecraftReflection.getMinecraftClass((String)"network.chat.ChatSender");
                    PlayerChatHelper.setupNameFields(chatSenderClass);
                }
            }
            catch (Throwable t) {
                ProtocolStringReplacer.warn("Unable to init PlayerChatHelper. PlayerChat packet handle may not work.", t);
            }
        }
    }

    public static enum Version {
        V8_0_TO_V18_2,
        V19_0,
        V19_1_TO_V19_2,
        V19_3,
        V19_4;

    }
}

