/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server.combat;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerPacketListener;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import org.jetbrains.annotations.NotNull;

public class CombatEvent
extends BaseServerPacketListener {
    public CombatEvent() {
        super(PacketType.Play.Server.COMBAT_EVENT, ListenType.COMBAT_KILL);
    }

    @Override
    protected void process(@NotNull PacketEvent packetEvent) {
        PsrUser user = this.getEventUser(packetEvent);
        if (user == null) {
            return;
        }
        PacketContainer packet = packetEvent.getPacket();
        StructureModifier chatComponents = packet.getChatComponents();
        if (packet.getCombatEvents().read(0) != EnumWrappers.CombatEventType.ENTITY_DIED) {
            return;
        }
        if (chatComponents.size() != 1) {
            StructureModifier strings = packet.getStrings();
            strings.write(0, (Object)CombatEvent.getReplacedText(packetEvent, user, this.listenType, (String)strings.read(0), this.filter));
            return;
        }
        String json = ((WrappedChatComponent)chatComponents.read(0)).getJson();
        WrappedChatComponent replaced = CombatEvent.getReplacedJsonWrappedComponent(packetEvent, user, this.listenType, json, this.filter);
        if (replaced != null) {
            chatComponents.write(0, (Object)replaced);
        }
    }
}

