/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server.scoreboard;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.api.exceptions.IncompatibleServerException;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerPacketListener;
import io.github.rothes.protocolstringreplacer.packetlistener.server.scoreboard.BaseUpdateTeamListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class UpdateTeamPost17
extends BaseUpdateTeamListener {
    private final Field displayName;
    private final Field prefix;
    private final Field suffix;

    public UpdateTeamPost17() {
        Class info = Arrays.stream(PacketType.Play.Server.SCOREBOARD_TEAM.getPacketClass().getDeclaredClasses()).filter(it -> !it.isInterface() && !it.isEnum()).findFirst().get();
        List collect = Arrays.stream(info.getDeclaredFields()).filter(it -> it.getType() == MinecraftReflection.getIChatBaseComponentClass()).collect(Collectors.toList());
        this.displayName = (Field)collect.get(0);
        this.displayName.setAccessible(true);
        this.prefix = (Field)collect.get(1);
        this.prefix.setAccessible(true);
        this.suffix = (Field)collect.get(2);
        this.suffix.setAccessible(true);
    }

    @Override
    protected void process(@NotNull PacketEvent packetEvent) {
        PsrUser user = this.getEventUser(packetEvent);
        if (user == null) {
            return;
        }
        PacketContainer packet = packetEvent.getPacket();
        Optional read = (Optional)packet.getModifier().withType(Optional.class).read(0);
        if (read == null || !read.isPresent()) {
            return;
        }
        Object o = read.get();
        if (this.processField(o, this.prefix, packetEvent, user, this.teamPrefixFilter)) {
            return;
        }
        if (this.processField(o, this.displayName, packetEvent, user, this.teamDNameFilter)) {
            return;
        }
        this.processField(o, this.suffix, packetEvent, user, this.teamSuffixFilter);
    }

    private boolean processField(Object infoObj, Field field, PacketEvent event, PsrUser user, BiPredicate<ReplacerConfig, PsrUser> filter) {
        try {
            Object handle = field.get(infoObj);
            if (handle == null) {
                return false;
            }
            WrappedChatComponent wrappedChatComponent = WrappedChatComponent.fromHandle((Object)handle);
            String json = wrappedChatComponent.getJson();
            String replacedJson = BaseServerPacketListener.getReplacedJson(event, user, this.listenType, json, filter);
            if (replacedJson == null) {
                return true;
            }
            wrappedChatComponent.setJson(replacedJson);
            field.set(infoObj, wrappedChatComponent.getHandle());
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleServerException(e);
        }
        return false;
    }
}

