/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.lib.org.apache.commons.collections.map.ListOrderedMap;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcher;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcherBuilder;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.replacer.MatchMode;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReplacerConfig
implements ReplacerConfig {
    private File file;
    private CommentYamlConfiguration configuration;
    private boolean enable;
    private int priority;
    private final List<ListenType> listenTypeList = new ArrayList<ListenType>();
    private MatchMode matchMode;
    private final HashMap<ReplaceMode, ListOrderedMap> replaces = new HashMap();
    private final HashMap<ReplaceMode, List<Object>> blocks = new HashMap();
    private String author;
    private String version;
    private boolean edited;
    private final HashMap<ReplaceMode, StringSearcher<String>> replacesStringSearcher = new HashMap();
    private final HashMap<ReplaceMode, StringSearcher<String>> blocksStringSearcher = new HashMap();
    private int maxTextLength = -1;
    private int maxJsonLength = -1;
    private int maxDirectLength = -1;
    private String permissionLimit;
    private List<String> windowTitleLimit;
    private boolean windowTitleLimitIgnoreInventory;
    private boolean handleScoreboardTitle;
    private boolean handleScoreboardEntityName;
    private boolean handleScoreboardTeamDisplayName;
    private boolean handleScoreboardTeamPrefix;
    private boolean handleScoreboardTeamSuffix;
    private boolean handleItemStackNbt;
    private boolean handleItemStackLore;
    private boolean handleItemStackDisplayEntries;
    private Set<Material> acceptedItemTypes;
    private HashSet<String> locales;

    public FileReplacerConfig(@Nonnull File file, @Nonnull CommentYamlConfiguration configuration) {
        long startTime = System.nanoTime();
        this.loadData(file, configuration);
        if (ProtocolStringReplacer.getInstance().getConfigManager().printReplacer) {
            ProtocolStringReplacer.info(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Replacer-Load-Complete", this.getRelativePath(), String.valueOf((double)(System.nanoTime() - startTime) / 1000000.0)));
        }
    }

    @Override
    public boolean isEdited() {
        return this.edited;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    @Override
    public CommentYamlConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public List<ListenType> getListenTypeList() {
        return this.listenTypeList;
    }

    @Override
    @NotNull
    public ListOrderedMap getReplaces(@Nonnull ReplaceMode replaceMode) {
        return this.replaces.get((Object)replaceMode);
    }

    @Override
    @NotNull
    public List<Object> getBlocks(@Nonnull ReplaceMode replaceMode) {
        return this.blocks.get((Object)replaceMode);
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.file.getAbsolutePath().substring((ProtocolStringReplacer.getInstance().getDataFolder().getAbsolutePath() + "\\").length()).replace('\\', '/');
    }

    @Override
    @NotNull
    public StringSearcher<String> getReplacesStringSearcher(ReplaceMode replaceMode) {
        return this.replacesStringSearcher.get((Object)replaceMode);
    }

    @Override
    @NotNull
    public StringSearcher<String> getBlocksStringSearcher(ReplaceMode replaceMode) {
        return this.blocksStringSearcher.get((Object)replaceMode);
    }

    @Override
    public void saveConfig() {
        this.configuration.set("Options.Enabled", this.enable);
        this.configuration.set("Options.Priority", this.priority);
        this.configuration.set("Options.Author", this.author);
        this.configuration.set("Options.Version", this.version);
        LinkedList<String> types = new LinkedList<String>();
        for (ListenType listenType : this.listenTypeList) {
            types.add(listenType.getName());
        }
        this.configuration.set("Options.Filter.Listen-Types", types);
        this.configuration.set("Options.Match-Mode", this.matchMode.getName());
        for (ReplaceMode replaceMode : ReplaceMode.values()) {
            ListOrderedMap replaces = this.replaces.get((Object)replaceMode);
            ArrayList<ListOrderedMap> result = new ArrayList<ListOrderedMap>();
            for (int i = 0; i < replaces.size(); i = (int)((short)(i + 1))) {
                ListOrderedMap entryMap = new ListOrderedMap();
                Object object = replaces.get(i);
                entryMap.put("Original", object.toString());
                entryMap.put("Replacement", replaces.get(object));
                result.add(entryMap);
            }
            this.configuration.set("Replaces." + replaceMode.getNode(), result);
            this.configuration.set("Blocks." + replaceMode.getNode(), this.blocks.get((Object)replaceMode).stream().map(Object::toString).collect(Collectors.toList()));
        }
        try {
            this.configuration.save(this.file);
            this.edited = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReplace(int index, @Nonnull String value, @Nonnull ReplaceMode replaceMode) {
        if (index < this.replaces.get((Object)replaceMode).size()) {
            this.replaces.get((Object)replaceMode).setValue(index, value);
            this.updateStringSearcher(replaceMode);
            this.edited = true;
            this.saveConfig();
        }
    }

    public void setReplace(int index, @Nonnull String key, @Nonnull String value, @Nonnull ReplaceMode replaceMode) {
        if (index < this.replaces.get((Object)replaceMode).size()) {
            this.removeReplace(index, replaceMode);
        }
        if (index <= this.replaces.get((Object)replaceMode).size()) {
            this.addReplace(index, key, value, replaceMode);
        }
    }

    public void addReplace(int index, @Nonnull String key, @Nonnull String value, @Nonnull ReplaceMode replaceMode) {
        if (index <= this.replaces.get((Object)replaceMode).size()) {
            if (this.matchMode == MatchMode.REGEX) {
                this.replaces.get((Object)replaceMode).put(index, Pattern.compile(key), value);
            } else {
                this.replaces.get((Object)replaceMode).put(index, key, value);
            }
            this.updateStringSearcher(replaceMode);
            this.edited = true;
            this.saveConfig();
        }
    }

    public void addReplace(@Nonnull String key, @Nonnull String value, @Nonnull ReplaceMode replaceMode) {
        this.addReplace(this.replaces.get((Object)replaceMode).size(), key, value, replaceMode);
    }

    public void removeReplace(int index, @Nonnull ReplaceMode replaceMode) {
        this.replaces.get((Object)replaceMode).remove(index);
        this.updateStringSearcher(replaceMode);
        this.edited = true;
        this.saveConfig();
    }

    public void setBlock(int index, @Nonnull String block, @Nonnull ReplaceMode replaceMode) {
        if (index < this.blocks.get((Object)replaceMode).size()) {
            this.blocks.get((Object)replaceMode).set(index, block);
            this.updateStringSearcher(replaceMode);
            this.edited = true;
            this.saveConfig();
        }
    }

    public void addBlock(int index, @Nonnull String block, @Nonnull ReplaceMode replaceMode) {
        if (index <= this.blocks.get((Object)replaceMode).size()) {
            if (this.matchMode == MatchMode.REGEX) {
                this.blocks.get((Object)replaceMode).add(index, Pattern.compile(block));
            } else {
                this.blocks.get((Object)replaceMode).add(index, block);
            }
            this.updateStringSearcher(replaceMode);
            this.edited = true;
            this.saveConfig();
        }
    }

    public void addBlock(@Nonnull String block, @Nonnull ReplaceMode replaceMode) {
        this.addBlock(this.blocks.get((Object)replaceMode).size(), block, replaceMode);
    }

    public void removeBlock(int index, @Nonnull ReplaceMode replaceMode) {
        this.blocks.get((Object)replaceMode).remove(index);
        this.updateStringSearcher(replaceMode);
        this.edited = true;
        this.saveConfig();
    }

    public int checkReplaceKey(@Nonnull String key, @Nonnull ReplaceMode replaceMode) {
        for (int i = 0; i < this.replaces.get((Object)replaceMode).size(); ++i) {
            if (!this.replaces.get((Object)replaceMode).get(i).toString().equals(key)) continue;
            return i;
        }
        return -1;
    }

    private void loadData(File file, CommentYamlConfiguration configuration) {
        boolean typeFound;
        this.configuration = configuration;
        this.file = file;
        if (!configuration.contains("Options.Enabled")) {
            ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Missing-Enabled-Warning", new String[0]));
        }
        this.enable = configuration.getBoolean("Options.Enabled", false);
        this.priority = configuration.getInt("Options.Priority", 5);
        this.author = configuration.getString("Options.Author");
        this.version = configuration.getString("Options.Version");
        List types = configuration.getStringList("Options.Filter.Listen-Types");
        if (types.isEmpty()) {
            ListenType[] listenTypes = ListenType.values();
            this.listenTypeList.addAll(Arrays.asList(listenTypes));
        } else {
            for (String type : types) {
                typeFound = false;
                ListenType[] listenTypeArray = ListenType.values();
                int n = listenTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    ListenType listenType = listenTypeArray[i];
                    if (!listenType.getName().equalsIgnoreCase(type)) continue;
                    typeFound = true;
                    this.listenTypeList.add(listenType);
                    break;
                }
                if (typeFound) continue;
                ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Invalid-Listen-Type", type));
            }
        }
        String matchMode = configuration.getString("Options.Match-Mode", "Contain");
        typeFound = false;
        for (MatchMode matchMode2 : MatchMode.values()) {
            if (!matchMode2.getName().equalsIgnoreCase(matchMode)) continue;
            this.matchMode = matchMode2;
            typeFound = true;
            break;
        }
        if (!typeFound) {
            this.matchMode = MatchMode.CONTAIN;
            ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Invalid-Match-Mode", matchMode));
        }
        for (Enum enum_ : ReplaceMode.values()) {
            ArrayList<Pattern> list;
            List mapList = configuration.getMapList("Replaces." + ((ReplaceMode)enum_).getNode());
            ListOrderedMap orderedMap = new ListOrderedMap();
            this.replaces.put((ReplaceMode)enum_, orderedMap);
            for (Map map : mapList) {
                Object original = map.get("Original");
                Object replacement = map.get("Replacement");
                if (original == null || replacement == null) continue;
                orderedMap.put(this.matchMode == MatchMode.REGEX ? Pattern.compile(original.toString()) : original.toString(), replacement.toString());
            }
            List loadedBlockList = configuration.getStringList("Blocks." + ((ReplaceMode)enum_).getNode());
            if (this.matchMode == MatchMode.REGEX) {
                list = new ArrayList<Pattern>();
                for (String string : loadedBlockList) {
                    list.add(Pattern.compile(string));
                }
            } else {
                list = new ArrayList(loadedBlockList);
            }
            this.blocks.put((ReplaceMode)enum_, list);
            this.updateStringSearcher((ReplaceMode)enum_);
        }
        this.loadOptionalFilters();
    }

    private void loadOptionalFilters() {
        this.maxTextLength = this.configuration.getInt("Options.Filter.Max-Length.Text", -1);
        if (this.maxTextLength <= 0) {
            this.maxTextLength = -1;
        }
        this.maxJsonLength = this.configuration.getInt("Options.Filter.Max-Length.Json", -1);
        if (this.maxJsonLength <= 0) {
            this.maxJsonLength = -1;
        }
        this.maxDirectLength = this.configuration.getInt("Options.Filter.Max-Length.Direct", -1);
        if (this.maxDirectLength <= 0) {
            this.maxDirectLength = -1;
        }
        this.permissionLimit = this.configuration.getString("Options.Filter.User.Permission", "");
        this.windowTitleLimit = this.configuration.getStringList("Options.Filter.ItemStack.Window-Title");
        this.windowTitleLimitIgnoreInventory = this.configuration.getBoolean("Options.Filter.ItemStack.Ignore-Inventory-Title", false);
        this.handleScoreboardTitle = this.configuration.getBoolean("Options.Filter.ScoreBoard.Handle-Title", false);
        this.handleScoreboardEntityName = this.configuration.getBoolean("Options.Filter.ScoreBoard.Handle-Entity-Name", false);
        this.handleScoreboardTeamDisplayName = this.configuration.getBoolean("Options.Filter.ScoreBoard.Handle-Team-Display-Name", false);
        this.handleScoreboardTeamPrefix = this.configuration.getBoolean("Options.Filter.ScoreBoard.Handle-Team-Prefix", false);
        this.handleScoreboardTeamSuffix = this.configuration.getBoolean("Options.Filter.ScoreBoard.Handle-Team-Suffix", false);
        this.handleItemStackNbt = this.configuration.getBoolean("Options.Filter.ItemStack.Handle-Nbt-Compound", false);
        this.handleItemStackLore = this.configuration.getBoolean("Options.Filter.ItemStack.Handle-Nbt-Lore-List", false);
        this.handleItemStackDisplayEntries = this.configuration.getBoolean("Options.Filter.ItemStack.Handle-Nbt-Display-Entries", true);
        List materialStrList = this.configuration.getStringList("Options.Filter.ItemStack.Handle-Item-Types");
        if (materialStrList.isEmpty()) {
            this.acceptedItemTypes = Collections.emptySet();
        } else {
            this.acceptedItemTypes = new HashSet<Material>(materialStrList.size());
            for (String mat : materialStrList) {
                Material material = Material.matchMaterial((String)mat);
                if (material == null) {
                    ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Unknown-Item-Type", mat));
                    continue;
                }
                this.acceptedItemTypes.add(material);
            }
        }
        this.locales = new HashSet();
        for (String s : this.configuration.getStringList("Options.Filter.User.Locales")) {
            this.locales.add(s.toLowerCase(Locale.ROOT).replace('-', '_'));
        }
    }

    private void updateStringSearcher(@Nonnull ReplaceMode replaceMode) {
        if (this.matchMode != MatchMode.CONTAIN) {
            return;
        }
        StringSearcherBuilder<String> builder = new StringSearcherBuilder().ignoreOverlaps();
        for (Map.Entry entry : this.getReplaces(replaceMode).entrySet()) {
            builder.addSearchString(entry.getKey().toString(), entry.getValue().toString());
        }
        this.replacesStringSearcher.put(replaceMode, builder.build());
        this.blocksStringSearcher.put(replaceMode, StringSearcher.builder().ignoreOverlaps().addSearchStrings(this.blocks.get((Object)replaceMode).toArray(new String[0])).build());
    }

    @Override
    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    @Override
    public int getMaxJsonLength() {
        return this.maxJsonLength;
    }

    @Override
    public int getMaxDirectLength() {
        return this.maxDirectLength;
    }

    @Override
    @NotNull
    public String getPermissionLimit() {
        return this.permissionLimit;
    }

    @Override
    @NotNull
    public List<String> getWindowTitleLimit() {
        return this.windowTitleLimit;
    }

    @Override
    public boolean windowTitleLimitIgnoreInventory() {
        return this.windowTitleLimitIgnoreInventory;
    }

    @Override
    public boolean handleScoreboardTitle() {
        return this.handleScoreboardTitle;
    }

    @Override
    public boolean handleScoreboardEntityName() {
        return this.handleScoreboardEntityName;
    }

    @Override
    public boolean handleScoreboardTeamDisplayName() {
        return this.handleScoreboardTeamDisplayName;
    }

    @Override
    public boolean handleScoreboardTeamPrefix() {
        return this.handleScoreboardTeamPrefix;
    }

    @Override
    public boolean handleScoreboardTeamSuffix() {
        return this.handleScoreboardTeamSuffix;
    }

    @Override
    public boolean handleItemStackNbt() {
        return this.handleItemStackNbt;
    }

    @Override
    public boolean handleItemStackLore() {
        return this.handleItemStackLore;
    }

    @Override
    public boolean handleItemStackDisplayEntries() {
        return this.handleItemStackDisplayEntries;
    }

    @Override
    @NotNull
    public Set<Material> acceptedItemTypes() {
        return this.acceptedItemTypes;
    }

    @Override
    public boolean acceptsLocale(String locale) {
        return locale == null || this.locales.isEmpty() || this.locales.contains(locale);
    }

    public String toString() {
        return "FileReplacerConfig{file=" + this.file + ", configuration=" + (Object)((Object)this.configuration) + ", enable=" + this.enable + ", priority=" + this.priority + ", listenTypeList=" + this.listenTypeList + ", matchMode=" + (Object)((Object)this.matchMode) + ", replaces=" + this.replaces + ", blocks=" + this.blocks + ", author='" + this.author + '\'' + ", version='" + this.version + '\'' + ", edited=" + this.edited + ", replacesStringSearcher=" + this.replacesStringSearcher + ", blocksStringSearcher=" + this.blocksStringSearcher + ", maxTextLength=" + this.maxTextLength + ", maxJsonLength=" + this.maxJsonLength + ", maxDirectLength=" + this.maxDirectLength + ", permissionLimit='" + this.permissionLimit + '\'' + ", windowTitleLimit=" + this.windowTitleLimit + ", windowTitleLimitIgnoreInventory=" + this.windowTitleLimitIgnoreInventory + ", handleScoreboardTitle=" + this.handleScoreboardTitle + ", handleScoreboardEntityName=" + this.handleScoreboardEntityName + ", handleScoreboardTeamDisplayName=" + this.handleScoreboardTeamDisplayName + ", handleScoreboardTeamPrefix=" + this.handleScoreboardTeamPrefix + ", handleScoreboardTeamSuffix=" + this.handleScoreboardTeamSuffix + ", handleItemStackNbt=" + this.handleItemStackNbt + ", handleItemStackDisplay=" + this.handleItemStackLore + ", handleItemStackDisplayEntries=" + this.handleItemStackDisplayEntries + ", acceptedItemTypes=" + this.acceptedItemTypes + ", locales=" + this.locales + '}';
    }
}

