/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.replacer.Replacer;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PAPIReplacer
implements Replacer {
    private final char head;
    private final char tail;

    public PAPIReplacer() {
        this.head = ProtocolStringReplacer.getInstance().getConfigManager().placeholderHead;
        this.tail = ProtocolStringReplacer.getInstance().getConfigManager().placeholderTail;
    }

    public char getHead() {
        return this.head;
    }

    public char getTail() {
        return this.tail;
    }

    @NotNull
    public String apply(@NotNull String text, @Nullable OfflinePlayer player, @NotNull Function<String, @Nullable PlaceholderExpansion> lookup) {
        char[] chars = text.toCharArray();
        StringBuilder builder = new StringBuilder(text.length());
        StringBuilder identifier = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char l = chars[i];
            if (l == '&' && ++i < chars.length) {
                char c = Character.toLowerCase(chars[i]);
                if (c != '0' && c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9' && c != 'a' && c != 'b' && c != 'c' && c != 'd' && c != 'e' && c != 'f' && c != 'k' && c != 'l' && c != 'm' && c != 'n' && c != 'o' && c != 'r' && c != 'x') {
                    builder.append(l).append(chars[i]);
                    continue;
                }
                builder.append('\u00a7');
                if (c != 'x') {
                    builder.append(chars[i]);
                    continue;
                }
                if (i > 1 && chars[i - 2] == '\\') {
                    builder.setLength(builder.length() - 2);
                    builder.append('&').append(chars[i]);
                    continue;
                }
                builder.append(c);
                int j = 0;
                while (++j <= 6 && i + j < chars.length) {
                    char x = chars[i + j];
                    builder.append('\u00a7').append(x);
                }
                if (j == 7) {
                    i += 6;
                    continue;
                }
                builder.setLength(builder.length() - j * 2);
                continue;
            }
            if (l != this.head || i + 1 >= chars.length) {
                builder.append(l);
                continue;
            }
            boolean identified = false;
            boolean oopsitsbad = true;
            boolean hadSpace = false;
            while (++i < chars.length) {
                char p = chars[i];
                if (p == ' ' && !identified) {
                    hadSpace = true;
                    break;
                }
                if (p == this.tail) {
                    oopsitsbad = false;
                    break;
                }
                if (p == '_' && !identified) {
                    identified = true;
                    continue;
                }
                if (identified) {
                    parameters.append(p);
                    continue;
                }
                identifier.append(p);
            }
            String identifierString = identifier.toString().toLowerCase();
            String parametersString = parameters.toString();
            identifier.setLength(0);
            parameters.setLength(0);
            if (oopsitsbad) {
                builder.append(this.head).append(identifierString);
                if (identified) {
                    builder.append('_').append(parametersString);
                }
                if (!hadSpace) continue;
                builder.append(' ');
                continue;
            }
            PlaceholderExpansion placeholder = lookup.apply(identifierString);
            if (placeholder == null) {
                builder.append(this.head).append(identifierString);
                if (identified) {
                    builder.append('_');
                }
                builder.append(parametersString).append(this.tail);
                continue;
            }
            String replacement = placeholder.onRequest(player, parametersString);
            if (replacement == null) {
                builder.append(this.head).append(identifierString);
                if (identified) {
                    builder.append('_');
                }
                builder.append(parametersString).append(this.tail);
                continue;
            }
            builder.append(ColorUtils.getColored(replacement));
        }
        return builder.toString();
    }
}

