/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer;

import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.Emit;
import io.github.rothes.protocolstringreplacer.replacer.FileReplacerConfig;
import io.github.rothes.protocolstringreplacer.replacer.PAPIReplacer;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.replacer.containers.Container;
import io.github.rothes.protocolstringreplacer.replacer.containers.Replaceable;
import io.github.rothes.protocolstringreplacer.util.FileUtils;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrScheduler;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.manager.LocalExpansionManager;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class ReplacerManager {
    private PAPIReplacer papiReplacer;
    private char papiHead;
    private char papiTail;
    private final List<ReplacerConfig> replacerConfigList = new ArrayList<ReplacerConfig>();
    private final ConcurrentHashMap<String, HandledItemCache> cacheTable = new ConcurrentHashMap();
    private PsrTask cleanTask;

    @Nonnull
    public static HashMap<File, CommentYamlConfiguration> loadReplacesFiles(@Nonnull File path) {
        Validate.notNull((Object)path, (String)"Path cannot be null");
        HashMap<File, CommentYamlConfiguration> loaded = new HashMap<File, CommentYamlConfiguration>();
        List<File> files = FileUtils.getFolderFiles(path, true, ".yml");
        for (File file : files) {
            try {
                CommentYamlConfiguration config = new CommentYamlConfiguration();
                config.load(file);
                loaded.put(file, config);
            }
            catch (Throwable e) {
                ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Replacer-Failed-To-Load", file.getAbsolutePath().substring((ProtocolStringReplacer.getInstance().getDataFolder().getAbsolutePath() + "\\").length()).replace('\\', '/')), e);
            }
        }
        return loaded;
    }

    public PsrTask getCleanTask() {
        return this.cleanTask;
    }

    public void cancelCleanTask() {
        if (this.getCleanTask() != null) {
            this.getCleanTask().cancel();
        }
    }

    public void registerTask() {
        ProtocolStringReplacer instance = ProtocolStringReplacer.getInstance();
        long cleanAccessInterval = instance.getConfigManager().cleanAccessInterval;
        long cleanTaskInterval = instance.getConfigManager().cleanTaskInterval;
        this.cleanTask = PsrScheduler.runTaskTimerAsynchronously(() -> {
            long currentTime = System.currentTimeMillis();
            int purged = 0;
            ArrayList<String> needToRemove = new ArrayList<String>();
            for (Map.Entry<String, HandledItemCache> entry : this.cacheTable.entrySet()) {
                needToRemove.clear();
                if (currentTime - entry.getValue().lastAccessTime > cleanAccessInterval) {
                    needToRemove.add(entry.getKey());
                }
                if (needToRemove.isEmpty()) continue;
                for (String cacheKey : needToRemove) {
                    this.cacheTable.remove(cacheKey);
                    ++purged;
                }
            }
            if (purged != 0) {
                ProtocolStringReplacer.info(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Schedule.Purging-Item-Cache", String.valueOf(purged)));
            }
        }, 0L, cleanTaskInterval);
    }

    public void initialize() {
        if (ProtocolStringReplacer.getInstance().getConfigManager().placeholderEnabled) {
            this.papiReplacer = new PAPIReplacer();
            this.papiHead = this.papiReplacer.getHead();
            this.papiTail = this.papiReplacer.getTail();
        }
        File path = new File(ProtocolStringReplacer.getInstance().getDataFolder() + "/Replacers");
        long startTime = System.nanoTime();
        HashMap<File, CommentYamlConfiguration> loadedFiles = ReplacerManager.loadReplacesFiles(path);
        ProtocolStringReplacer.info(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Pre-Loaded-Replacers", String.valueOf(loadedFiles.size()), String.valueOf((double)(System.nanoTime() - startTime) / 1000000.0)));
        if (loadedFiles.isEmpty()) {
            return;
        }
        for (Map.Entry<File, CommentYamlConfiguration> entry : loadedFiles.entrySet()) {
            File file = entry.getKey();
            CommentYamlConfiguration config = entry.getValue();
            try {
                FileReplacerConfig replacerConfig = new FileReplacerConfig(file, config);
                this.addReplacerConfig(replacerConfig);
            }
            catch (PatternSyntaxException ex) {
                ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Replacer-Regex-Exception", file.getAbsolutePath().substring((ProtocolStringReplacer.getInstance().getDataFolder().getAbsolutePath() + "\\").length()).replace('\\', '/')), ex);
            }
            catch (Throwable throwable) {
                ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Replacer-Config.Replacer-Throw-Exception", file.getAbsolutePath().substring((ProtocolStringReplacer.getInstance().getDataFolder().getAbsolutePath() + "\\").length()).replace('\\', '/')), throwable);
            }
        }
    }

    public void addReplacerConfig(ReplacerConfig replacerConfig) {
        int size = this.replacerConfigList.size();
        for (int i = 0; i <= size; ++i) {
            if (i == this.replacerConfigList.size()) {
                this.replacerConfigList.add(replacerConfig);
                continue;
            }
            if (replacerConfig.getPriority() <= this.replacerConfigList.get(i).getPriority()) continue;
            this.replacerConfigList.add(i, replacerConfig);
            break;
        }
    }

    public List<ReplacerConfig> getReplacerConfigList() {
        return new ArrayList<ReplacerConfig>(this.replacerConfigList);
    }

    public void saveReplacerConfigs() {
        for (ReplacerConfig replacerConfig : this.replacerConfigList) {
            if (!replacerConfig.isEdited()) continue;
            replacerConfig.saveConfig();
        }
    }

    @Nullable
    public HandledItemCache getReplacedItemCache(String original) {
        return this.cacheTable.get(original);
    }

    public HandledItemCache addReplacedItemCache(String original, @NotNull ReadWriteNBT nbtItem, boolean blocked, int[] papiIndexes) {
        Validate.notNull((Object)nbtItem, (String)"Replaced NBTItem cannot be null");
        HandledItemCache handledItemCache = new HandledItemCache(nbtItem, System.currentTimeMillis(), blocked, papiIndexes);
        this.cacheTable.put(original, handledItemCache);
        return handledItemCache;
    }

    public List<ReplacerConfig> getAcceptedReplacers(@Nonnull PsrUser user, @Nonnull BiPredicate<ReplacerConfig, PsrUser> filter) {
        Validate.notNull((Object)user, (String)"PsrUser cannot be null");
        Validate.notNull(filter, (String)"BiPredicate Filter cannot be null");
        LinkedList<ReplacerConfig> result = new LinkedList<ReplacerConfig>(this.replacerConfigList);
        result.removeIf(replacerConfig -> !filter.test((ReplacerConfig)replacerConfig, user));
        return result;
    }

    public boolean isJsonBlocked(@Nonnull Container<?> container, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull(container, (String)"Container cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        for (Replaceable replaceable : container.getJsons()) {
            String json = replaceable.getText();
            if (json.isEmpty()) continue;
            int length = json.length();
            for (ReplacerConfig replacerConfig : replacerConfigList) {
                int maxLength = replacerConfig.getMaxJsonLength();
                if (maxLength != -1 && maxLength < length || !this.getBlocked(json, replacerConfig, ReplaceMode.JSON)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTextBlocked(@Nonnull Container<?> container, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull(container, (String)"Container cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        for (Replaceable replaceable : container.getTexts()) {
            String text = replaceable.getText();
            if (text.isEmpty()) continue;
            int length = text.length();
            for (ReplacerConfig replacerConfig : replacerConfigList) {
                int maxLength = replacerConfig.getMaxTextLength();
                if (maxLength != -1 && maxLength < length || !this.getBlocked(text, replacerConfig, ReplaceMode.COMMON)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDirectBlocked(@Nonnull String string, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        if (string.isEmpty()) {
            return false;
        }
        int length = string.length();
        for (ReplacerConfig replacerConfig : replacerConfigList) {
            int maxLength = replacerConfig.getMaxDirectLength();
            if (maxLength != -1 && maxLength < length || !this.getBlocked(string, replacerConfig, ReplaceMode.DIRECT)) continue;
            return true;
        }
        return false;
    }

    public void replaceContainerJsons(@Nonnull Container<?> container, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull(container, (String)"Container cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        for (Replaceable replaceable : container.getJsons()) {
            String json = replaceable.getText();
            if (json.isEmpty()) continue;
            int length = json.length();
            for (ReplacerConfig replacerConfig : replacerConfigList) {
                int maxLength = replacerConfig.getMaxJsonLength();
                if (maxLength != -1 && maxLength < length) continue;
                json = this.getReplaced(json, replacerConfig, ReplaceMode.JSON);
            }
            replaceable.setText(json);
        }
    }

    public void replaceJsonReplaceable(@Nonnull Replaceable replaceable, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull((Object)replaceable, (String)"Replaceable cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        String json = replaceable.getText();
        if (json.isEmpty()) {
            return;
        }
        int length = json.length();
        for (ReplacerConfig replacerConfig : replacerConfigList) {
            int maxLength = replacerConfig.getMaxJsonLength();
            if (maxLength != -1 && maxLength < length) continue;
            json = this.getReplaced(json, replacerConfig, ReplaceMode.JSON);
        }
        replaceable.setText(json);
    }

    public void replaceContainerTexts(@Nonnull Container<?> container, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull(container, (String)"Container cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        for (Replaceable replaceable : container.getTexts()) {
            String text = replaceable.getText();
            if (text.isEmpty()) continue;
            int length = text.length();
            for (ReplacerConfig replacerConfig : replacerConfigList) {
                int maxLength = replacerConfig.getMaxTextLength();
                if (maxLength != -1 && maxLength < length) continue;
                text = this.getReplaced(text, replacerConfig, ReplaceMode.COMMON);
            }
            replaceable.setText(text);
        }
    }

    public String replaceDirect(@Nonnull String string, @Nonnull List<ReplacerConfig> replacerConfigList) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        Validate.notNull(replacerConfigList, (String)"List cannot be null");
        if (string.isEmpty()) {
            return string;
        }
        int length = string.length();
        String result = string;
        for (ReplacerConfig replacerConfig : replacerConfigList) {
            int maxLength = replacerConfig.getMaxDirectLength();
            if (maxLength != -1 && maxLength < length) continue;
            result = this.getReplaced(result, replacerConfig, ReplaceMode.DIRECT);
        }
        return result;
    }

    public void setPapi(@Nonnull PsrUser user, @Nonnull List<Replaceable> replaceables) {
        Validate.notNull((Object)user, (String)"PsrUser cannot be null");
        Validate.notNull(replaceables, (String)"List cannot be null");
        if (!user.hasPermission("protocolstringreplacer.feature.parsepapi")) {
            return;
        }
        List<Integer> indexes = this.getPapiIndexes(replaceables);
        if (indexes.isEmpty()) {
            return;
        }
        for (int i : indexes) {
            Replaceable replaceable = replaceables.get(i);
            replaceable.setText(this.setPlaceholder(user, replaceable.getText()));
        }
    }

    public void setPapi(@Nonnull PsrUser user, @Nonnull List<Replaceable> replaceables, int[] indexes) {
        Validate.notNull((Object)user, (String)"PsrUser cannot be null");
        Validate.notNull(replaceables, (String)"List cannot be null");
        Validate.notNull((Object)indexes, (String)"List cannot be null");
        if (!user.hasPermission("protocolstringreplacer.feature.parsepapi")) {
            return;
        }
        for (int i : indexes) {
            Replaceable replaceable = replaceables.get(i);
            replaceable.setText(this.setPlaceholder(user, replaceable.getText()));
        }
    }

    public List<Integer> getPapiIndexes(@Nonnull List<Replaceable> replaceables) {
        Validate.notNull(replaceables, (String)"List cannot be null");
        if (!ProtocolStringReplacer.getInstance().getConfigManager().placeholderEnabled) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < replaceables.size(); ++i) {
            Replaceable replaceable = replaceables.get(i);
            if (!this.hasPlaceholder(replaceable.getText())) continue;
            result.add(i);
        }
        return result;
    }

    public boolean hasPlaceholder(@NotNull String string) {
        boolean findHead = true;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (findHead) {
                if (ch != this.papiHead) continue;
                findHead = false;
                continue;
            }
            if (ch != this.papiTail) continue;
            return true;
        }
        return false;
    }

    public String setPlaceholder(@NotNull PsrUser user, @NotNull String string) {
        return this.papiReplacer.apply(string, (OfflinePlayer)user.getPlayer(), arg_0 -> ((LocalExpansionManager)PlaceholderAPIPlugin.getInstance().getLocalExpansionManager()).getExpansion(arg_0));
    }

    @Nonnull
    private String getReplaced(@Nonnull String string, @Nonnull ReplacerConfig replacerConfig, @Nonnull ReplaceMode replaceMode) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        Validate.notNull((Object)replacerConfig, (String)"Replacer File cannot be null");
        Validate.notNull((Object)((Object)replaceMode), (String)"Replaces Mode cannot be null");
        switch (replacerConfig.getMatchMode()) {
            case CONTAIN: {
                int i = 0;
                StringBuilder resultBuilder = new StringBuilder();
                for (Emit<String> emit : replacerConfig.getReplacesStringSearcher(replaceMode).parseText(string)) {
                    if (emit.getStart() > i) {
                        resultBuilder.append(string, i, emit.getStart());
                    }
                    resultBuilder.append(emit.getPayload());
                    i = emit.getEnd() + 1;
                }
                if (i < string.length()) {
                    resultBuilder.append(string.substring(i));
                }
                return resultBuilder.toString();
            }
            case EQUAL: {
                Object get = replacerConfig.getReplaces(replaceMode).get(string);
                if (get != null) {
                    return (String)get;
                }
                return string;
            }
            case REGEX: {
                String result = string;
                Set set = replacerConfig.getReplaces(replaceMode).entrySet();
                for (Map.Entry entry : set) {
                    result = ((Pattern)entry.getKey()).matcher(result).replaceAll((String)entry.getValue());
                }
                return result;
            }
        }
        throw new AssertionError();
    }

    public boolean getBlocked(@Nonnull String string, @Nonnull ReplacerConfig replacerConfig, @Nonnull ReplaceMode replaceMode) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        Validate.notNull((Object)replacerConfig, (String)"Replacer File cannot be null");
        Validate.notNull((Object)((Object)replaceMode), (String)"Replaces Mode cannot be null");
        switch (replacerConfig.getMatchMode()) {
            case CONTAIN: {
                return replacerConfig.getBlocksStringSearcher(replaceMode).containsMatch(string);
            }
            case EQUAL: {
                return replacerConfig.getBlocks(replaceMode).contains(string);
            }
            case REGEX: {
                List<Object> blocks = replacerConfig.getBlocks(replaceMode);
                for (Object patternObject : blocks) {
                    Pattern pattern = (Pattern)patternObject;
                    if (!pattern.matcher(string).find()) continue;
                    return true;
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    public static class HandledItemCache {
        private final ReadWriteNBT nbtItem;
        private long lastAccessTime;
        private boolean blocked;
        private int[] placeholderIndexes;

        public HandledItemCache(ReadWriteNBT nbtItem, long lastAccessTime, boolean blocked, int[] placeholderIndexes) {
            this.nbtItem = nbtItem;
            this.lastAccessTime = lastAccessTime;
            this.blocked = blocked;
            this.placeholderIndexes = placeholderIndexes;
        }

        public ReadWriteNBT getNbt() {
            return this.nbtItem;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public boolean isBlocked() {
            return this.blocked;
        }

        public int[] getPlaceholderIndexes() {
            return this.placeholderIndexes;
        }

        public void setPlaceholderIndexes(int[] placeholderIndexes) {
            this.placeholderIndexes = placeholderIndexes;
        }

        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public void setBlocked(boolean blocked) {
            this.blocked = blocked;
        }
    }
}

