/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer.containers;

import io.github.rothes.protocolstringreplacer.replacer.containers.AbstractContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.ComponentsContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.Container;
import io.github.rothes.protocolstringreplacer.replacer.helpers.ItemHelper;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.hover.content.Item;
import org.jetbrains.annotations.NotNull;

public class ItemContentContainer
extends AbstractContainer<Item> {
    protected ItemHelper helper;

    public ItemContentContainer(@NotNull Item item) {
        super(item);
    }

    public ItemContentContainer(@NotNull Item item, @NotNull Container<?> root) {
        super(item, root);
    }

    @Override
    public void createDefaultChildren() {
        this.helper = ItemHelper.parse((Item)this.content);
        if (this.helper.hasName()) {
            this.children.add(new ComponentsContainer(this.helper.getName(), this.root){

                @Override
                public BaseComponent[] getResult() {
                    BaseComponent[] result = (BaseComponent[])super.getResult();
                    ItemContentContainer.this.helper.setName(result);
                    return result;
                }
            });
        }
        if (this.helper.hasLore()) {
            int size = this.helper.getLoreSize();
            for (int line = 0; line < size; ++line) {
                final int finalLine = line;
                this.children.add(new ComponentsContainer(this.helper.getLore(line), this.root){

                    @Override
                    public BaseComponent[] getResult() {
                        BaseComponent[] result = (BaseComponent[])super.getResult();
                        ItemContentContainer.this.helper.setLore(finalLine, result);
                        return result;
                    }
                });
            }
        }
        super.createDefaultChildren();
    }

    @Override
    public Item getResult() {
        Item result = (Item)super.getResult();
        this.helper.saveChanges();
        return result;
    }
}

