/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer.containers;

import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTContainer;
import de.tr7zw.nbtapi.NBTList;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.replacer.containers.AbstractContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.ChatJsonContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.Container;
import org.jetbrains.annotations.NotNull;

public class SignNbtContainer
extends AbstractContainer<NBTContainer> {
    private static final boolean POST_20 = ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 20;

    public SignNbtContainer(@NotNull NBTContainer nbtContainer) {
        super(nbtContainer);
    }

    public SignNbtContainer(@NotNull NBTContainer nbtContainer, @NotNull Container<?> root) {
        super(nbtContainer, root);
    }

    @Override
    public void createDefaultChildren() {
        this.children.add(new ChatJsonContainer(((NBTContainer)this.content).toString(), this.root, false){

            @Override
            @NotNull
            public String getResult() {
                String result = super.getResult();
                ((NBTContainer)SignNbtContainer.this.content).clearNBT();
                ((NBTContainer)SignNbtContainer.this.content).mergeCompound((NBTCompound)new NBTContainer(result));
                return result;
            }
        });
    }

    public void entriesPeriod() {
        this.children.clear();
        this.jsonReplaceables.clear();
        if (POST_20) {
            NBTCompound compound = ((NBTContainer)this.content).getCompound("front_text");
            if (compound != null) {
                this.addLines((NBTList<String>)compound.getStringList("messages"));
            }
            if ((compound = ((NBTContainer)this.content).getCompound("back_text")) != null) {
                this.addLines((NBTList<String>)compound.getStringList("messages"));
            }
        } else {
            for (int i = 1; i <= 4; ++i) {
                String key = "Text" + i;
                String original = ((NBTContainer)this.content).getString(key);
                if (original == null || original.equals("null")) {
                    original = "{\"text\":\"\"}";
                }
                final String finalKey = key;
                final String finalOriginal = original;
                this.children.add(new ChatJsonContainer(finalOriginal, this.root, true){

                    @Override
                    @NotNull
                    public String getResult() {
                        String result = super.getResult();
                        if (!result.equals(finalOriginal)) {
                            ((NBTContainer)SignNbtContainer.this.content).setString(finalKey, result);
                        }
                        return result;
                    }
                });
            }
        }
    }

    private void addLines(final NBTList<String> list) {
        int i = 0;
        while (i < 4) {
            final String original = (String)list.get(i);
            final int finalIndex = i++;
            this.children.add(new ChatJsonContainer(original, this.root, true){

                @Override
                @NotNull
                public String getResult() {
                    String result = super.getResult();
                    if (!result.equals(original)) {
                        list.set(finalIndex, (Object)result);
                    }
                    return result;
                }
            });
        }
    }

    public String getNbtString() {
        return ((NBTContainer)this.content).toString();
    }

    public void createDefaultChildrenDeep() {
        super.createDefaultChildren();
    }
}

