/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.upgrade;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.lib.org.apache.commons.collections.map.ListOrderedMap;
import io.github.rothes.protocolstringreplacer.upgrade.DotConfigUpgradeHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class UpgradeHandler2To3
extends DotConfigUpgradeHandler {
    @Override
    public void upgrade() {
        this.upgradeAllReplacerConfigs(new File(ProtocolStringReplacer.getInstance().getDataFolder() + "/Replacers"));
        CommentYamlConfiguration config = ProtocolStringReplacer.getInstance().getConfig();
        config.set("Configs-Version", 3);
        try {
            config.save(ProtocolStringReplacer.getInstance().getConfigFile());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void upgradeReplacerConfig(@NotNull File file, @NotNull YamlConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("Replaces");
        if (section != null) {
            ListOrderedMap keyValueHashMap = new ListOrderedMap();
            Pattern commentKeyPattern = CommentYamlConfiguration.getCommentKeyPattern();
            Pattern splitPattern = Pattern.compile("\\| ");
            for (Object key : section.getKeys(false)) {
                Object value = section.get((String)key);
                if (!(value instanceof String)) continue;
                String valueString = (String)value;
                if (commentKeyPattern.matcher((CharSequence)key).find()) {
                    String[] split = splitPattern.split(valueString);
                    value = split[0] + "|   " + split[1];
                }
                keyValueHashMap.put(key, value);
                section.set((String)key, null);
            }
            section.set("23307\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"0|   # \u5e38\u89c4\u6587\u672c\u66ff\u6362\u6a21\u5f0f.");
            Set set = keyValueHashMap.entrySet();
            for (Map.Entry entry : set) {
                section.set("Common\u9c20" + (String)entry.getKey(), entry.getValue());
            }
            try {
                config.save(file);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }
}

