/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.upgrade;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.lib.org.apache.commons.collections.map.ListOrderedMap;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.upgrade.DotConfigUpgradeHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class UpgradeHandler3To4
extends DotConfigUpgradeHandler {
    @Override
    public void upgrade() {
        CommentYamlConfiguration config = ProtocolStringReplacer.getInstance().getConfig();
        Pattern commentPattern = CommentYamlConfiguration.getCommentKeyPattern();
        ArrayList<String> comments = new ArrayList<String>();
        for (String key : config.getKeys(true)) {
            if (commentPattern.matcher(key).find()) {
                comments.add(key);
                continue;
            }
            if (key.equals("Options.Features.Packet-Listener.Listen-Dropped-Item-Entity")) {
                for (String comment : comments) {
                    config.set(comment, null);
                }
                config.set("Options.Features.Packet-Listener.Listen-Dropped-Item-Entity", null);
            }
            comments.clear();
        }
        config.set("Configs-Version", 4);
        config.set("Options.Features.ItemMetaCache.Purge-Task-Interval", config.getInt("Options.Features.ItemMetaCache.Clean-Task-Interval", 600));
        config.set("Options.Features.ItemMetaCache.Purge-Access-Interval", config.getInt("Options.Features.ItemMetaCache.Clean-Task-Interval", 300));
        try {
            config.save(ProtocolStringReplacer.getInstance().getConfigFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.upgradeAllReplacerConfigs(new File(ProtocolStringReplacer.getInstance().getDataFolder() + "/Replacers"));
    }

    @Override
    protected void upgradeReplacerConfig(@NotNull File file, @NotNull YamlConfiguration config) {
        this.typeToMode(config);
        this.updateReplacesStructure(config);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateReplacesStructure(@NotNull YamlConfiguration config) {
        for (ReplaceMode replaceMode : ReplaceMode.values()) {
            String pathString = "Replaces\u9c20" + replaceMode.getNode();
            ConfigurationSection section = config.getConfigurationSection(pathString);
            if (section == null) continue;
            LinkedList<String> comments = new LinkedList<String>();
            ListOrderedMap replaces = new ListOrderedMap();
            Pattern splitPattern = Pattern.compile("\\| ");
            Pattern commentKeyPattern = CommentYamlConfiguration.getCommentKeyPattern();
            for (String key : section.getKeys(true)) {
                Object value = section.get(key);
                if (!(value instanceof String)) continue;
                String stringVaule = (String)value;
                if (commentKeyPattern.matcher(key).find()) {
                    comments.add(0, splitPattern.split(stringVaule)[1]);
                    continue;
                }
                replaces.put(key, stringVaule);
            }
            int commentIndex = 1000;
            int lineIndex = 0;
            for (String comment : comments) {
                config.set("Replaces\u9c20" + commentIndex++ + "\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)(lineIndex++ + "| " + comment));
            }
            config.set(pathString, null);
            ArrayList<ListOrderedMap> replacesList = new ArrayList<ListOrderedMap>();
            Set set = replaces.entrySet();
            for (Map.Entry entry : set) {
                ListOrderedMap entryMap = new ListOrderedMap();
                entryMap.put("Original", entry.getKey());
                entryMap.put("Replacement", entry.getValue());
                replacesList.add(entryMap);
            }
            if (replacesList.isEmpty()) continue;
            config.set(pathString, replacesList);
        }
    }

    private void typeToMode(@NotNull YamlConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("Options");
        if (section != null) {
            ListOrderedMap comments = new ListOrderedMap();
            Pattern commentKeyPattern = CommentYamlConfiguration.getCommentKeyPattern();
            int commentIndex = 6789;
            for (String key : section.getKeys(false)) {
                Object value = section.get(key);
                if (!(value instanceof String)) continue;
                String valueString = (String)value;
                if (commentKeyPattern.matcher(key).find()) {
                    comments.put(key, valueString);
                    continue;
                }
                if (key.equals("Match-Type")) {
                    Set set = comments.entrySet();
                    for (Map.Entry entry : set) {
                        section.set((String)entry.getKey(), null);
                        section.set(commentIndex++ + "\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", entry.getValue());
                    }
                    section.set("Match-Mode", (Object)valueString);
                    section.set(key, null);
                    return;
                }
                comments.clear();
            }
        }
    }
}

