/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.util;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.capture.CaptureInfo;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;

public class MessageUtils {
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static void sendCaptureInfo(@Nonnull PsrUser user, @Nonnull CaptureInfo info, int index) {
        Validate.notNull((Object)info, (String)"CaptureInfo cannot be null");
        String time = dateFormat.format(new Date(info.getTime()));
        ComponentBuilder hoverTextBuilder = new ComponentBuilder(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Captured-Contents", new String[0])).append("\n").append("\u00a7b\u00a7lCommons: " + (info.getTexts().isEmpty() ? "\u00a7fN/A\n" : "\n"));
        for (String text : info.getTexts()) {
            hoverTextBuilder.append("\u00a76\u00a7l- ");
            hoverTextBuilder.append(ColorUtils.showColorCodes(text) + "\n").color(null);
        }
        hoverTextBuilder.append("\n\u00a7b\u00a7lJsons: " + (info.getJsons().isEmpty() ? "\u00a7fN/A\n" : "\n"));
        for (String json : info.getJsons()) {
            hoverTextBuilder.append("\u00a76\u00a7l- ");
            hoverTextBuilder.append(json + "\n").color(null);
        }
        hoverTextBuilder.append("\n\u00a7b\u00a7lDirects: " + (info.getDirects().isEmpty() ? "\u00a7fN/A\n" : "\n"));
        for (String direct : info.getDirects()) {
            hoverTextBuilder.append("\u00a76\u00a7l- ");
            if (ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 12) {
                hoverTextBuilder.append(TextComponent.fromLegacyText((String)(ColorUtils.showColorCodes(direct, true) + "\n")));
                continue;
            }
            hoverTextBuilder.append(ColorUtils.showColorCodes(direct, true) + "\n");
        }
        if (info.getExtra() != null) {
            hoverTextBuilder.append("\n");
            StringBuilder sb = new StringBuilder();
            for (BaseComponent baseComponent : info.getExtra()) {
                sb.append(baseComponent.toLegacyText());
            }
            hoverTextBuilder.append(sb.append("\n").toString());
        }
        hoverTextBuilder.append(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-For-Clipboard", new String[0]));
        ComponentBuilder captureMessageBuilder = new ComponentBuilder("").append("\u00a73 \u00a7l" + info.getListenType().getName() + "\u00a73: \u00a7b" + time + (info.getCount() > 1 ? " \u00a77x" + info.getCount() : "")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverTextBuilder.create())).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/psr capture clipboard " + info.getListenType().getName() + " " + index));
        user.sendFilteredMessage(captureMessageBuilder.create());
    }

    public static void sendCaptureInfoClipboard(@Nonnull PsrUser user, @Nonnull CaptureInfo info) {
        ClickEvent clickEvent;
        Validate.notNull((Object)info, (String)"CaptureInfo cannot be null");
        user.sendFilteredText("\u00a7b\u00a7lCommons: " + (info.getTexts().isEmpty() ? "\u00a7fN/A" : ""));
        for (String text : info.getTexts()) {
            clickEvent = ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 15 ? new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text) : new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, text);
            user.sendFilteredMessage(new ComponentBuilder(" - ").color(ChatColor.GOLD).bold(true).event(clickEvent).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-To-Copy", new String[0])))).append("").color(null).bold(false).append(ColorUtils.showColorCodes(text)).create());
        }
        user.sendFilteredText("\u00a7b\u00a7lJsons: " + (info.getJsons().isEmpty() ? "\u00a7fN/A" : ""));
        for (String json : info.getJsons()) {
            clickEvent = ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 15 ? new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, json) : new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, json);
            user.sendFilteredMessage(new ComponentBuilder(" - ").color(ChatColor.GOLD).bold(true).event(clickEvent).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-To-Copy", new String[0])))).append("").color(null).bold(false).append(json).create());
        }
        user.sendFilteredText("\u00a7b\u00a7lDirects: " + (info.getDirects().isEmpty() ? "\u00a7fN/A" : ""));
        for (String direct : info.getDirects()) {
            clickEvent = ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 15 ? new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, direct) : new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, direct);
            ComponentBuilder clickableMsg = new ComponentBuilder(" - ").color(ChatColor.GOLD).bold(true).event(clickEvent).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-To-Copy", new String[0])))).append("").color(null).bold(false);
            if (ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 12) {
                clickableMsg.append(TextComponent.fromLegacyText((String)ColorUtils.showColorCodes(direct, true)));
            } else {
                clickableMsg.append(ColorUtils.showColorCodes(direct, true));
            }
            user.sendFilteredMessage(clickableMsg.create());
        }
        if (info.getExtra() != null) {
            user.sendFilteredMessage(info.getExtra());
        }
    }

    public static void sendPageButtons(@Nonnull PsrUser user, @Nonnull String command, int currentPage, int totalPage) {
        Validate.notNull((Object)user, (String)"PsrUser cannot be null");
        Validate.notNull((Object)command, (String)"Command String cannot be null");
        ComponentBuilder pageComponent = new ComponentBuilder("");
        if (currentPage > 1) {
            pageComponent.append(" \u25c0 ").event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command + (currentPage - 1))).color(ChatColor.YELLOW);
        } else {
            pageComponent.append("   ");
        }
        pageComponent.append(PsrLocalization.getLocaledMessage("Utils.Message.Page-Info", String.valueOf(currentPage), String.valueOf(totalPage)));
        if (currentPage < totalPage) {
            pageComponent.append(" \u25b6 ").event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command + (currentPage + 1))).color(ChatColor.YELLOW);
        }
        user.sendFilteredMessage(pageComponent.create());
    }
}

