/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.EntitySerializer;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.ItemSerializer;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.api.chat.hover.content.TextSerializer;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.KeybindComponentSerializer;
import net.md_5.bungee.chat.ScoreComponentSerializer;
import net.md_5.bungee.chat.SelectorComponentSerializer;
import net.md_5.bungee.chat.TextComponentSerializer;
import net.md_5.bungee.chat.TranslatableComponentSerializer;
import net.md_5.bungee.chat.VersionedComponentSerializer;

public class SpigotUtils {
    private static final Gson psrSerializer;
    private static final JsonParser jsonParser;

    public static BaseComponent[] parseComponents(String json) {
        try {
            JsonElement jsonElement = jsonParser.parse(json);
            if (jsonElement.isJsonArray()) {
                return (BaseComponent[])psrSerializer.fromJson(jsonElement, BaseComponent[].class);
            }
            return new BaseComponent[]{(BaseComponent)psrSerializer.fromJson(jsonElement, BaseComponent.class)};
        }
        catch (Throwable t) {
            return ComponentSerializer.parse((String)json);
        }
    }

    public static String serializeComponents(BaseComponent ... components) {
        try {
            if (components.length == 1) {
                return psrSerializer.toJson((Object)components[0]);
            }
            return psrSerializer.toJson((Object)new TextComponent(components));
        }
        catch (Throwable t) {
            return ComponentSerializer.toString((BaseComponent[])components);
        }
    }

    public static boolean compareComponents(BaseComponent[] a2, BaseComponent[] b2) {
        if (a2 == null && b2 != null || a2 != null && b2 == null) {
            return false;
        }
        if (a2 == null) {
            return true;
        }
        if (a2.length != b2.length) {
            return false;
        }
        int length = a2.length;
        for (int i = 0; i < length; ++i) {
            BaseComponent component = a2[i];
            BaseComponent other = b2[i];
            if (!component.toLegacyText().equals(other.toLegacyText())) {
                return false;
            }
            if (component.getHoverEvent() == other.getHoverEvent() || component.getHoverEvent() == null || SpigotUtils.compareComponents(component.getHoverEvent().getValue(), other.getHoverEvent().getValue())) continue;
            return false;
        }
        return true;
    }

    private static Object newInstance(Class<?> clazz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    static {
        jsonParser = new JsonParser();
        Gson temp = null;
        ProtocolStringReplacer plugin = ProtocolStringReplacer.getInstance();
        try {
            Class<VersionedComponentSerializer> clazz;
            VersionedComponentSerializer instance = null;
            if (plugin.getServerMajorVersion() == 21 && plugin.getServerMinorVersion() >= 5 || plugin.getServerMinorVersion() > 21) {
                clazz = VersionedComponentSerializer.class;
                instance = VersionedComponentSerializer.forVersion((ChatVersion)ChatVersion.V1_21_5);
            } else {
                clazz = ComponentSerializer.class;
            }
            for (Field declaredField : clazz.getDeclaredFields()) {
                if (declaredField.getType() != Gson.class) continue;
                declaredField.setAccessible(true);
                temp = (Gson)declaredField.get(instance);
                try {
                    temp = temp.newBuilder().disableHtmlEscaping().create();
                }
                catch (NoSuchMethodError e) {
                    GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
                    try {
                        gsonBuilder.registerTypeAdapter(BaseComponent.class, (Object)new ComponentSerializer()).registerTypeAdapter(TextComponent.class, SpigotUtils.newInstance(TextComponentSerializer.class)).registerTypeAdapter(TranslatableComponent.class, SpigotUtils.newInstance(TranslatableComponentSerializer.class)).registerTypeAdapter(KeybindComponent.class, SpigotUtils.newInstance(KeybindComponentSerializer.class)).registerTypeAdapter(ScoreComponent.class, SpigotUtils.newInstance(ScoreComponentSerializer.class)).registerTypeAdapter(SelectorComponent.class, SpigotUtils.newInstance(SelectorComponentSerializer.class)).registerTypeAdapter(Entity.class, SpigotUtils.newInstance(EntitySerializer.class)).registerTypeAdapter(Text.class, (Object)new TextSerializer()).registerTypeAdapter(Item.class, (Object)new ItemSerializer()).registerTypeAdapter(ItemTag.class, (Object)new ItemTag.Serializer());
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                    temp = gsonBuilder.create();
                }
                break;
            }
        }
        catch (Throwable e) {
            ProtocolStringReplacer.error("Unable to disableHtmlEscaping for SpigotComponentSerializer:", e);
        }
        psrSerializer = temp;
    }
}

