/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.util.scheduler;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public final class PsrTask {
    private static final boolean FOLIA = ProtocolStringReplacer.getInstance().isFolia();
    private final Object task;
    private final int taskId;

    public PsrTask(ScheduledTask task) {
        this.task = task;
        this.taskId = -1;
    }

    public PsrTask(BukkitTask task) {
        this.task = task;
        this.taskId = task.getTaskId();
    }

    public PsrTask(int taskId) {
        this.task = null;
        this.taskId = taskId;
    }

    public void cancel() {
        if (FOLIA) {
            ((ScheduledTask)this.task).cancel();
        } else if (this.task != null) {
            ((BukkitTask)this.task).cancel();
        } else {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    public boolean isCancelled() {
        if (this.task == null) {
            throw new IllegalStateException("Task is created by id");
        }
        if (FOLIA) {
            return ((ScheduledTask)this.task).isCancelled();
        }
        return ((BukkitTask)this.task).isCancelled();
    }

    public boolean isActive() {
        if (this.task == null) {
            throw new IllegalStateException("Task is created by id");
        }
        if (FOLIA) {
            ScheduledTask.ExecutionState state = ((ScheduledTask)this.task).getExecutionState();
            return state != ScheduledTask.ExecutionState.FINISHED && state != ScheduledTask.ExecutionState.CANCELLED;
        }
        int taskId = ((BukkitTask)this.task).getTaskId();
        BukkitScheduler scheduler = Bukkit.getScheduler();
        return scheduler.isCurrentlyRunning(taskId) || scheduler.isQueued(taskId);
    }
}

