/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.cosmosinfinia.network.ChoosePlanetButtonMessage;
import net.mcreator.cosmosinfinia.procedures.CanGoToTier2PlanetsProcedure;
import net.mcreator.cosmosinfinia.procedures.ReturnRocketProcedure;
import net.mcreator.cosmosinfinia.world.inventory.ChoosePlanetMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ChoosePlanetScreen
extends AbstractContainerScreen<ChoosePlanetMenu> {
    private static final HashMap<String, Object> guistate = ChoosePlanetMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_earth;
    Button button_moon;
    Button button_mars;
    Button button_asteroid_belt;
    Button button_venus;
    Button button_mercury;
    Button button_titan;
    Button button_launch;
    Button button_eoz;
    Button button_europa;

    public ChoosePlanetScreen(ChoosePlanetMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ReturnRocketProcedure.execute((Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + -66, this.topPos + 171, 30, 1.5f, 0.0f, livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.label_tier_1_cosmo_bodies"), -12, -11, -1, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.label_tier_2_cosmo_bodies"), -12, 41, -1, false);
    }

    public void init() {
        super.init();
        this.button_earth = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_earth"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ChoosePlanetButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + -11, this.topPos + -1, 36, 20).build();
        guistate.put("button:button_earth", this.button_earth);
        this.addRenderableWidget((GuiEventListener)this.button_earth);
        this.button_moon = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_moon"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(1, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ChoosePlanetButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }).bounds(this.leftPos + 26, this.topPos + -1, 31, 20).build();
        guistate.put("button:button_moon", this.button_moon);
        this.addRenderableWidget((GuiEventListener)this.button_moon);
        this.button_mars = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_mars"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(2, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ChoosePlanetButtonMessage.handleButtonAction(this.entity, 2, this.x, this.y, this.z);
        }).bounds(this.leftPos + 58, this.topPos + -1, 31, 20).build();
        guistate.put("button:button_mars", this.button_mars);
        this.addRenderableWidget((GuiEventListener)this.button_mars);
        this.button_asteroid_belt = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_asteroid_belt"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(3, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ChoosePlanetButtonMessage.handleButtonAction(this.entity, 3, this.x, this.y, this.z);
        }).bounds(this.leftPos + 90, this.topPos + -1, 79, 20).build();
        guistate.put("button:button_asteroid_belt", this.button_asteroid_belt);
        this.addRenderableWidget((GuiEventListener)this.button_asteroid_belt);
        this.button_venus = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_venus"), e -> {
            if (CanGoToTier2PlanetsProcedure.execute((Entity)this.entity)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(4, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ChoosePlanetButtonMessage.handleButtonAction(this.entity, 4, this.x, this.y, this.z);
            }
        }).bounds(this.leftPos + 39, this.topPos + 51, 39, 20).build(builder -> new Button((Button.Builder)builder){

            public void renderWidget(GuiGraphics guiGraphics, int gx, int gy, float ticks) {
                this.visible = CanGoToTier2PlanetsProcedure.execute((Entity)ChoosePlanetScreen.this.entity);
                super.renderWidget(guiGraphics, gx, gy, ticks);
            }
        });
        guistate.put("button:button_venus", this.button_venus);
        this.addRenderableWidget((GuiEventListener)this.button_venus);
        this.button_mercury = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_mercury"), e -> {
            if (CanGoToTier2PlanetsProcedure.execute((Entity)this.entity)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(5, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ChoosePlanetButtonMessage.handleButtonAction(this.entity, 5, this.x, this.y, this.z);
            }
        }).bounds(this.leftPos + -11, this.topPos + 51, 49, 20).build(builder -> new Button((Button.Builder)builder){

            public void renderWidget(GuiGraphics guiGraphics, int gx, int gy, float ticks) {
                this.visible = CanGoToTier2PlanetsProcedure.execute((Entity)ChoosePlanetScreen.this.entity);
                super.renderWidget(guiGraphics, gx, gy, ticks);
            }
        });
        guistate.put("button:button_mercury", this.button_mercury);
        this.addRenderableWidget((GuiEventListener)this.button_mercury);
        this.button_titan = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_titan"), e -> {
            if (CanGoToTier2PlanetsProcedure.execute((Entity)this.entity)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(6, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ChoosePlanetButtonMessage.handleButtonAction(this.entity, 6, this.x, this.y, this.z);
            }
        }).bounds(this.leftPos + 79, this.topPos + 51, 39, 20).build(builder -> new Button((Button.Builder)builder){

            public void renderWidget(GuiGraphics guiGraphics, int gx, int gy, float ticks) {
                this.visible = CanGoToTier2PlanetsProcedure.execute((Entity)ChoosePlanetScreen.this.entity);
                super.renderWidget(guiGraphics, gx, gy, ticks);
            }
        });
        guistate.put("button:button_titan", this.button_titan);
        this.addRenderableWidget((GuiEventListener)this.button_titan);
        this.button_launch = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_launch"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(7, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ChoosePlanetButtonMessage.handleButtonAction(this.entity, 7, this.x, this.y, this.z);
        }).bounds(this.leftPos + -11, this.topPos + 151, 44, 20).build();
        guistate.put("button:button_launch", this.button_launch);
        this.addRenderableWidget((GuiEventListener)this.button_launch);
        this.button_eoz = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_eoz"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(8, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ChoosePlanetButtonMessage.handleButtonAction(this.entity, 8, this.x, this.y, this.z);
        }).bounds(this.leftPos + -11, this.topPos + 20, 27, 20).build();
        guistate.put("button:button_eoz", this.button_eoz);
        this.addRenderableWidget((GuiEventListener)this.button_eoz);
        this.button_europa = Button.builder((Component)Component.translatable((String)"gui.cosmos_infinia.choose_planet.button_europa"), e -> {
            if (CanGoToTier2PlanetsProcedure.execute((Entity)this.entity)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ChoosePlanetButtonMessage(9, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ChoosePlanetButtonMessage.handleButtonAction(this.entity, 9, this.x, this.y, this.z);
            }
        }).bounds(this.leftPos + 119, this.topPos + 51, 50, 20).build(builder -> new Button((Button.Builder)builder){

            public void renderWidget(GuiGraphics guiGraphics, int gx, int gy, float ticks) {
                this.visible = CanGoToTier2PlanetsProcedure.execute((Entity)ChoosePlanetScreen.this.entity);
                super.renderWidget(guiGraphics, gx, gy, ticks);
            }
        });
        guistate.put("button:button_europa", this.button_europa);
        this.addRenderableWidget((GuiEventListener)this.button_europa);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

