/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeleclipsids<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cosmos_infinia", (String)"modeleclipsids"), "main");
    public final ModelPart legs;
    public final ModelPart left_leg;
    public final ModelPart right_leg;
    public final ModelPart body;
    public final ModelPart headwear;
    public final ModelPart head;
    public final ModelPart arms;
    public final ModelPart left_arm;
    public final ModelPart right_arm;

    public Modeleclipsids(ModelPart root) {
        this.legs = root.getChild("legs");
        this.left_leg = this.legs.getChild("left_leg");
        this.right_leg = this.legs.getChild("right_leg");
        this.body = this.legs.getChild("body");
        this.headwear = this.body.getChild("headwear");
        this.head = this.headwear.getChild("head");
        this.arms = this.body.getChild("arms");
        this.left_arm = this.arms.getChild("left_arm");
        this.right_arm = this.arms.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition legs = partdefinition.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition left_leg = legs.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(42, 31).addBox(-2.0f, 0.0f, -1.5f, 4.0f, 25.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.25f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = legs.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(42, 31).mirror().addBox(-2.0f, 0.0f, -1.5f, 4.0f, 25.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.25f, (float)0.0f, (float)0.0f));
        PartDefinition body = legs.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -20.0f, -2.5f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 47).addBox(-4.5f, -10.0f, -2.0f, 9.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headwear = body.addOrReplaceChild("headwear", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)-20.0f, (float)0.0f));
        PartDefinition head = headwear.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition arms = body.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)31.0f, (float)0.0f));
        PartDefinition left_arm = arms.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 0).addBox(0.0f, -2.0f, -1.5f, 3.0f, 28.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-49.0f, (float)0.0f));
        PartDefinition right_arm = arms.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-3.0f, -2.0f, -1.5f, 3.0f, 28.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-49.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.legs.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

