/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.cosmosinfinia.entity.ParasitefishEntity;
import net.mcreator.cosmosinfinia.procedures.ParasitefishDisplayConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ParasitefishRenderer
extends MobRenderer<ParasitefishEntity, SilverfishModel<ParasitefishEntity>> {
    public ParasitefishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SilverfishModel(context.bakeLayer(ModelLayers.SILVERFISH)), 0.0f);
        this.addLayer((RenderLayer)new RenderLayer<ParasitefishEntity, SilverfishModel<ParasitefishEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"cosmos_infinia:textures/entities/alien_parasiteglow3.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ParasitefishEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                double z;
                double y;
                double x;
                Level world = entity.level();
                if (ParasitefishDisplayConditionProcedure.execute((LevelAccessor)world, x = entity.getX(), y = entity.getY(), z = entity.getZ())) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((SilverfishModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(ParasitefishEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.1f, 1.1f, 1.1f);
    }

    public ResourceLocation getTextureLocation(ParasitefishEntity entity) {
        return ResourceLocation.parse((String)"cosmos_infinia:textures/entities/alien_parasitemain.png");
    }

    protected boolean isBodyVisible(ParasitefishEntity entity) {
        return false;
    }
}

