/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.init;

import net.mcreator.cosmosinfinia.entity.CryofishEntity;
import net.mcreator.cosmosinfinia.entity.EcliptridEntity;
import net.mcreator.cosmosinfinia.entity.MutatedEcliptridEntity;
import net.mcreator.cosmosinfinia.entity.ParasitefishEntity;
import net.mcreator.cosmosinfinia.entity.ThalasstricFishEntity;
import net.mcreator.cosmosinfinia.entity.Tier1RocketEntity;
import net.mcreator.cosmosinfinia.entity.Tier2RocketEntity;
import net.mcreator.cosmosinfinia.entity.Tier3RocketEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CosmosInfiniaModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"cosmos_infinia");
    public static final DeferredHolder<EntityType<?>, EntityType<Tier1RocketEntity>> TIER_1_ROCKET = CosmosInfiniaModEntities.register("tier_1_rocket", EntityType.Builder.of(Tier1RocketEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 3.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<Tier2RocketEntity>> TIER_2_ROCKET = CosmosInfiniaModEntities.register("tier_2_rocket", EntityType.Builder.of(Tier2RocketEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 3.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<ParasitefishEntity>> PARASITEFISH = CosmosInfiniaModEntities.register("parasitefish", EntityType.Builder.of(ParasitefishEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<CryofishEntity>> CRYOFISH = CosmosInfiniaModEntities.register("cryofish", EntityType.Builder.of(CryofishEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<EcliptridEntity>> ECLIPTRID = CosmosInfiniaModEntities.register("ecliptrid", EntityType.Builder.of(EcliptridEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 3.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<Tier3RocketEntity>> TIER_3_ROCKET = CosmosInfiniaModEntities.register("tier_3_rocket", EntityType.Builder.of(Tier3RocketEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 3.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<ThalasstricFishEntity>> THALASSTRIC_FISH = CosmosInfiniaModEntities.register("thalasstric_fish", EntityType.Builder.of(ThalasstricFishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MutatedEcliptridEntity>> MUTATED_ECLIPTRID = CosmosInfiniaModEntities.register("mutated_ecliptrid", EntityType.Builder.of(MutatedEcliptridEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        Tier1RocketEntity.init(event);
        Tier2RocketEntity.init(event);
        ParasitefishEntity.init(event);
        CryofishEntity.init(event);
        EcliptridEntity.init(event);
        Tier3RocketEntity.init(event);
        ThalasstricFishEntity.init(event);
        MutatedEcliptridEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)TIER_1_ROCKET.get(), Tier1RocketEntity.createAttributes().build());
        event.put((EntityType)TIER_2_ROCKET.get(), Tier2RocketEntity.createAttributes().build());
        event.put((EntityType)PARASITEFISH.get(), ParasitefishEntity.createAttributes().build());
        event.put((EntityType)CRYOFISH.get(), CryofishEntity.createAttributes().build());
        event.put((EntityType)ECLIPTRID.get(), EcliptridEntity.createAttributes().build());
        event.put((EntityType)TIER_3_ROCKET.get(), Tier3RocketEntity.createAttributes().build());
        event.put((EntityType)THALASSTRIC_FISH.get(), ThalasstricFishEntity.createAttributes().build());
        event.put((EntityType)MUTATED_ECLIPTRID.get(), MutatedEcliptridEntity.createAttributes().build());
    }
}

