/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.network;

import java.util.HashMap;
import net.mcreator.cosmosinfinia.CosmosInfiniaMod;
import net.mcreator.cosmosinfinia.procedures.GoAsteroidBeltProcedure;
import net.mcreator.cosmosinfinia.procedures.GoEOZProcedure;
import net.mcreator.cosmosinfinia.procedures.GoEarthProcedure;
import net.mcreator.cosmosinfinia.procedures.GoEuropaProcedure;
import net.mcreator.cosmosinfinia.procedures.GoMarsProcedure;
import net.mcreator.cosmosinfinia.procedures.GoMercuryProcedure;
import net.mcreator.cosmosinfinia.procedures.GoMoonProcedure;
import net.mcreator.cosmosinfinia.procedures.GoTitanProcedure;
import net.mcreator.cosmosinfinia.procedures.GoVenusProcedure;
import net.mcreator.cosmosinfinia.procedures.LaunchRocketProcedure;
import net.mcreator.cosmosinfinia.world.inventory.ChoosePlanetMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ChoosePlanetButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChoosePlanetButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cosmos_infinia", (String)"choose_planet_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChoosePlanetButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ChoosePlanetButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ChoosePlanetButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ChoosePlanetButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ChoosePlanetButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = ChoosePlanetMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GoEarthProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GoMoonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            GoMarsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GoAsteroidBeltProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GoVenusProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GoMercuryProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GoTitanProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            LaunchRocketProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            GoEOZProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            GoEuropaProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CosmosInfiniaMod.addNetworkMessage(TYPE, STREAM_CODEC, ChoosePlanetButtonMessage::handleData);
    }
}

