/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.procedures;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class CloudsRenderProcedure {
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static VertexBuffer cloudBuffer = null;
    private static CloudStatus cloudStatus = null;
    private static double x = 0.0;
    private static double y = 0.0;
    private static double z = 0.0;
    private static float width = 12.0f;
    private static float height = 4.0f;
    private static final Predicate<Object[]> PREDICATE = params -> {
        ticks = (Integer)params[1];
        partialTick = ((Float)params[2]).floatValue();
        poseStack = (PoseStack)params[3];
        modelViewMatrix = (Matrix4f)params[7];
        projectionMatrix = (Matrix4f)params[8];
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (entity != null) {
            ClientLevel level = minecraft.level;
            Vec3 pos = entity.getPosition(partialTick);
            CloudsRenderProcedure.execute(null);
            return true;
        }
        return false;
    };

    private static void buildClouds(CloudStatus cloudStatus, double x, double y, double z) {
        if (cloudBuffer == null || CloudsRenderProcedure.cloudStatus != cloudStatus || CloudsRenderProcedure.x != x || CloudsRenderProcedure.y != y || CloudsRenderProcedure.z != z) {
            CloudsRenderProcedure.cloudStatus = cloudStatus;
            CloudsRenderProcedure.x = x;
            CloudsRenderProcedure.y = y;
            CloudsRenderProcedure.z = z;
            Minecraft minecraft = Minecraft.getInstance();
            RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
            float du = 1.0f / (float)GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            float dv = 1.0f / (float)GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            float dx = (float)Mth.floor((double)x) * du;
            float dz = (float)Mth.floor((double)z) * dv;
            float cloudY = (float)Math.floor(y / (double)height) * height;
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
            if (cloudStatus == CloudStatus.FANCY) {
                for (int i = -3; i <= 4; ++i) {
                    for (int j = -3; j <= 4; ++j) {
                        int k;
                        float cloudX = (float)i * 8.0f;
                        float cloudZ = (float)j * 8.0f;
                        if (cloudY > -height - 1.0f) {
                            bufferBuilder.addVertex(cloudX, cloudY, cloudZ + 8.0f).setUv(cloudX * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(0.7f, 0.7f, 0.7f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(cloudX + 8.0f, cloudY, cloudZ + 8.0f).setUv((cloudX + 8.0f) * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(0.7f, 0.7f, 0.7f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(cloudX + 8.0f, cloudY, cloudZ).setUv((cloudX + 8.0f) * du + dx, cloudZ * dv + dz).setColor(0.7f, 0.7f, 0.7f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(cloudX, cloudY, cloudZ).setUv(cloudX * du + dx, cloudZ * dv + dz).setColor(0.7f, 0.7f, 0.7f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                        }
                        if (cloudY <= height + 1.0f) {
                            bufferBuilder.addVertex(cloudX, cloudY + height - 9.765625E-4f, cloudZ + 8.0f).setUv(cloudX * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
                            bufferBuilder.addVertex(cloudX + 8.0f, cloudY + height - 9.765625E-4f, cloudZ + 8.0f).setUv((cloudX + 8.0f) * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
                            bufferBuilder.addVertex(cloudX + 8.0f, cloudY + height - 9.765625E-4f, cloudZ).setUv((cloudX + 8.0f) * du + dx, cloudZ * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
                            bufferBuilder.addVertex(cloudX, cloudY + height - 9.765625E-4f, cloudZ).setUv(cloudX * du + dx, cloudZ * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
                        }
                        if (i > -1) {
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.addVertex(cloudX + (float)k, cloudY, cloudZ + 8.0f).setUv((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(-1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(cloudX + (float)k, cloudY + height, cloudZ + 8.0f).setUv((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(-1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(cloudX + (float)k, cloudY + height, cloudZ).setUv((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(-1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(cloudX + (float)k, cloudY, cloudZ).setUv((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(-1.0f, 0.0f, 0.0f);
                            }
                        }
                        if (i <= 1) {
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.addVertex(cloudX + (float)k + 1.0f - 9.765625E-4f, cloudY, cloudZ + 8.0f).setUv((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(cloudX + (float)k + 1.0f - 9.765625E-4f, cloudY + height, cloudZ + 8.0f).setUv((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(cloudX + (float)k + 1.0f - 9.765625E-4f, cloudY + height, cloudZ).setUv((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(cloudX + (float)k + 1.0f - 9.765625E-4f, cloudY, cloudZ).setUv((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).setColor(0.9f, 0.9f, 0.9f, 1.0f).setNormal(1.0f, 0.0f, 0.0f);
                            }
                        }
                        if (j > -1) {
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.addVertex(cloudX, cloudY + height, cloudZ + (float)k).setUv(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, -1.0f);
                                bufferBuilder.addVertex(cloudX + 8.0f, cloudY + height, cloudZ + (float)k).setUv((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, -1.0f);
                                bufferBuilder.addVertex(cloudX + 8.0f, cloudY, cloudZ + (float)k).setUv((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, -1.0f);
                                bufferBuilder.addVertex(cloudX, cloudY, cloudZ + (float)k).setUv(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, -1.0f);
                            }
                        }
                        if (j > 1) continue;
                        for (k = 0; k < 8; ++k) {
                            bufferBuilder.addVertex(cloudX, cloudY + height, cloudZ + (float)k + 1.0f - 9.765625E-4f).setUv(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, 1.0f);
                            bufferBuilder.addVertex(cloudX + 8.0f, cloudY + height, cloudZ + (float)k + 1.0f - 9.765625E-4f).setUv((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, 1.0f);
                            bufferBuilder.addVertex(cloudX + 8.0f, cloudY, cloudZ + (float)k + 1.0f - 9.765625E-4f).setUv((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, 1.0f);
                            bufferBuilder.addVertex(cloudX, cloudY, cloudZ + (float)k + 1.0f - 9.765625E-4f).setUv(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).setColor(0.8f, 0.8f, 0.8f, 1.0f).setNormal(0.0f, 0.0f, 1.0f);
                        }
                    }
                }
            } else if (cloudStatus == CloudStatus.FAST) {
                for (int i = -32; i < 32; i += 32) {
                    for (int j = -32; j < 32; j += 32) {
                        bufferBuilder.addVertex((float)i, cloudY, (float)(j + 32)).setUv((float)i * du + dx, (float)(j + 32) * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferBuilder.addVertex((float)(i + 32), cloudY, (float)(j + 32)).setUv((float)(i + 32) * du + dx, (float)(j + 32) * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferBuilder.addVertex((float)(i + 32), cloudY, (float)j).setUv((float)(i + 32) * du + dx, (float)j * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferBuilder.addVertex((float)i, cloudY, (float)j).setUv((float)i * du + dx, (float)j * dv + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setNormal(0.0f, -1.0f, 0.0f);
                    }
                }
            }
            if (cloudBuffer != null) {
                cloudBuffer.close();
            }
            cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            cloudBuffer.bind();
            cloudBuffer.upload(bufferBuilder.buildOrThrow());
        } else {
            cloudBuffer.bind();
        }
    }

    public static void renderClouds(CloudStatus cloudStatus, double altitude, double vx, double vz, int color) {
        if (cloudStatus == CloudStatus.OFF) {
            return;
        }
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
        int tw = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) << 3;
        int th = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) << 3;
        if (tw > 0 && th > 0) {
            Minecraft minecraft = Minecraft.getInstance();
            Vec3 pos = minecraft.gameRenderer.getMainCamera().getPosition();
            double factor = (double)((float)ticks + partialTick) * 0.03;
            double x = (pos.x() + factor * -vx) / (double)width;
            double y = altitude + 0.33 - pos.y();
            double z = (pos.z() + factor * -vz) / (double)width + 0.33;
            x -= (double)(Mth.floor((double)(x / (double)tw)) * tw);
            z -= (double)(Mth.floor((double)(z / (double)th)) * th);
            float dx = (float)(x - (double)Mth.floor((double)x));
            float dy = (float)(y / (double)height - (double)Mth.floor((double)(y / (double)height))) * height;
            float dz = (float)(z - (double)Mth.floor((double)z));
            CloudsRenderProcedure.buildClouds(cloudStatus, x, y, z);
            poseStack.pushPose();
            poseStack.mulPose(modelViewMatrix);
            poseStack.scale(width, 1.0f, width);
            poseStack.translate(-dx, dy, -dz);
            Matrix4f matrix4f = poseStack.last().pose();
            ShaderInstance shaderInstance = GameRenderer.getRendertypeCloudsShader();
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            if (cloudStatus == CloudStatus.FANCY) {
                RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                cloudBuffer.drawWithShader(matrix4f, projectionMatrix, shaderInstance);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                cloudBuffer.drawWithShader(matrix4f, projectionMatrix, shaderInstance);
            } else if (cloudStatus == CloudStatus.FAST) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                cloudBuffer.drawWithShader(matrix4f, projectionMatrix, shaderInstance);
            }
            VertexBuffer.unbind();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void cloudsSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_CLOUDS").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute() {
        CloudsRenderProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }
}

