/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.procedures;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class WeatherRenderProcedure {
    private static float partialTick = 0.0f;
    private static int ticks = 0;
    private static final Predicate<Object[]> PREDICATE = params -> {
        ticks = (Integer)params[1];
        partialTick = ((Float)params[2]).floatValue();
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (entity != null) {
            ClientLevel level = minecraft.level;
            Vec3 pos = entity.getPosition(partialTick);
            WeatherRenderProcedure.execute(null);
            return true;
        }
        return false;
    };

    public static void renderRain(float speed, int x, int z, int range, int color, boolean constant) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Vec3 pos = minecraft.gameRenderer.getMainCamera().getPosition();
        double camX = pos.x();
        double camY = pos.y();
        double camZ = pos.z();
        int iCamX = Mth.floor((double)camX);
        int iCamY = Mth.floor((double)camY);
        int iCamZ = Mth.floor((double)camZ);
        int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
        int length = Minecraft.useFancyGraphics() ? 10 : 5;
        int btm = iCamY - (range > length ? range : length);
        int top = iCamY + (range > length ? range : length);
        if (btm < height) {
            btm = height;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= level.getRainLevel(partialTick);
        }
        if (top > height) {
            int idx = x - iCamX;
            int idz = z - iCamZ;
            double r = Mth.sqrt((float)(idx * idx + idz * idz));
            double vecX = (double)(-idz) / r * 0.5;
            double vecZ = (double)idx / r * 0.5;
            RandomSource randomSource = RandomSource.create((long)(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761));
            int counts = ticks + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
            float anime = -(((float)counts + partialTick) * speed) / 32.0f * (3.0f + randomSource.nextFloat());
            double dx = (double)((float)x + 0.5f) - camX;
            double dz = (double)((float)z + 0.5f) - camZ;
            if (range > 0) {
                float coef = (float)Math.sqrt(dx * dx + dz * dz) / (float)range;
                alpha = (alpha *= (1.0f - coef * coef) * 0.5f + 0.5f) < 0.0f ? 0.0f : alpha;
            }
            int y = iCamY < height ? height : iCamY;
            int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            bufferBuilder.addVertex((float)((double)x - camX - vecX + 0.5), (float)((double)top - camY), (float)((double)z - camZ - vecZ + 0.5)).setUv(0.0f, (float)btm * 0.25f + anime).setColor(red, green, blue, alpha).setLight(packedLight);
            bufferBuilder.addVertex((float)((double)x - camX - vecX + 0.5), (float)((double)btm - camY), (float)((double)z - camZ - vecZ + 0.5)).setUv(0.0f, (float)top * 0.25f + anime).setColor(red, green, blue, alpha).setLight(packedLight);
            bufferBuilder.addVertex((float)((double)x - camX + vecX + 0.5), (float)((double)btm - camY), (float)((double)z - camZ + vecZ + 0.5)).setUv(1.0f, (float)top * 0.25f + anime).setColor(red, green, blue, alpha).setLight(packedLight);
            bufferBuilder.addVertex((float)((double)x - camX + vecX + 0.5), (float)((double)top - camY), (float)((double)z - camZ + vecZ + 0.5)).setUv(1.0f, (float)btm * 0.25f + anime).setColor(red, green, blue, alpha).setLight(packedLight);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        }
    }

    public static void renderSnow(float speed, int x, int z, int range, int color, boolean constant) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Vec3 pos = minecraft.gameRenderer.getMainCamera().getPosition();
        double camX = pos.x();
        double camY = pos.y();
        double camZ = pos.z();
        int iCamX = Mth.floor((double)camX);
        int iCamY = Mth.floor((double)camY);
        int iCamZ = Mth.floor((double)camZ);
        int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
        int length = Minecraft.useFancyGraphics() ? 10 : 5;
        int btm = iCamY - (range > length ? range : length);
        int top = iCamY + (range > length ? range : length);
        if (btm < height) {
            btm = height;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= level.getRainLevel(partialTick);
        }
        if (top > height) {
            RandomSource randomSource = RandomSource.create((long)(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761));
            int idx = x - iCamX;
            int idz = z - iCamZ;
            double r = Mth.sqrt((float)(idx * idx + idz * idz));
            double vecX = (double)(-idz) / r * 0.5;
            double vecZ = (double)idx / r * 0.5;
            float anime = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
            float time = (float)ticks + partialTick;
            float du = (float)(randomSource.nextDouble() + randomSource.nextGaussian() * (double)time * 0.01) * speed;
            float dv = (float)(randomSource.nextDouble() + randomSource.nextGaussian() * (double)time * 0.001) * (speed / 10.0f);
            double dx = (double)((float)x + 0.5f) - camX;
            double dz = (double)((float)z + 0.5f) - camZ;
            if (range > 0) {
                float coef = (float)Math.sqrt(dx * dx + dz * dz) / (float)range;
                alpha = (alpha *= (1.0f - coef * coef) * 0.5f + 0.5f) < 0.0f ? 0.0f : alpha;
            }
            int y = iCamY < height ? height : iCamY;
            int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            int sky = ((packedLight & 0xFFFF) * 3 + 240) / 4;
            int block = ((packedLight >> 16 & 0xFFFF) * 3 + 240) / 4;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            bufferBuilder.addVertex((float)((double)x - camX - vecX + 0.5), (float)((double)top - camY), (float)((double)z - camZ - vecZ + 0.5)).setUv(0.0f + du, (float)btm * 0.25f + anime + dv).setColor(red, green, blue, alpha).setUv2(sky, block);
            bufferBuilder.addVertex((float)((double)x - camX - vecX + 0.5), (float)((double)btm - camY), (float)((double)z - camZ - vecZ + 0.5)).setUv(0.0f + du, (float)top * 0.25f + anime + dv).setColor(red, green, blue, alpha).setUv2(sky, block);
            bufferBuilder.addVertex((float)((double)x - camX + vecX + 0.5), (float)((double)btm - camY), (float)((double)z - camZ + vecZ + 0.5)).setUv(1.0f + du, (float)top * 0.25f + anime + dv).setColor(red, green, blue, alpha).setUv2(sky, block);
            bufferBuilder.addVertex((float)((double)x - camX + vecX + 0.5), (float)((double)top - camY), (float)((double)z - camZ + vecZ + 0.5)).setUv(1.0f + du, (float)btm * 0.25f + anime + dv).setColor(red, green, blue, alpha).setUv2(sky, block);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        }
    }

    public static void renderWeather(boolean rain, boolean snow, float speed, int range, int color, boolean constant) {
        if (range > 0) {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            Vec3 pos = minecraft.gameRenderer.getMainCamera().getPosition();
            int ix = Mth.floor((double)pos.x());
            int iy = Mth.floor((double)pos.y());
            int iz = Mth.floor((double)pos.z());
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    BlockPos blockPos = new BlockPos(ix + i, iy, iz + j);
                    Biome biome = (Biome)level.getBiome(blockPos).value();
                    if (!biome.hasPrecipitation()) continue;
                    Biome.Precipitation precipitation = biome.getPrecipitationAt(blockPos);
                    if (rain && precipitation == Biome.Precipitation.RAIN) {
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/environment/rain.png"));
                        WeatherRenderProcedure.renderRain(speed, ix + i, iz + j, range, color, constant);
                    }
                    if (!snow || precipitation != Biome.Precipitation.SNOW) continue;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/environment/snow.png"));
                    WeatherRenderProcedure.renderSnow(speed, ix + i, iz + j, range, color, constant);
                }
            }
        }
    }

    @SubscribeEvent
    public static void weatherSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_WEATHER").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute() {
        WeatherRenderProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }
}

