/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.procedures;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class WeatherSoundsParticlesProcedure {
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static ParticleOptions genericParticle = ParticleTypes.RAIN;
    private static ParticleOptions specialParticle = ParticleTypes.SMOKE;
    private static SoundEvent genericSound = SoundEvents.WEATHER_RAIN;
    private static SoundEvent specialSound = SoundEvents.WEATHER_RAIN_ABOVE;
    private static final Predicate<Object[]> PREDICATE = params -> {
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        partialTick = minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        ticks = (Integer)params[1];
        if (entity != null) {
            ClientLevel level = minecraft.level;
            Vec3 pos = entity.getPosition(partialTick);
            WeatherSoundsParticlesProcedure.execute(null);
            return true;
        }
        return false;
    };

    public static void setParticles(ParticleOptions genericParticle, ParticleOptions specialParticle) {
        WeatherSoundsParticlesProcedure.genericParticle = genericParticle;
        WeatherSoundsParticlesProcedure.specialParticle = specialParticle;
    }

    public static void setSounds(SoundEvent genericSound, SoundEvent specialSound) {
        WeatherSoundsParticlesProcedure.genericSound = genericSound;
        WeatherSoundsParticlesProcedure.specialSound = specialSound;
    }

    public static void addEffects(int target, float power, int range, boolean particles, boolean sounds, boolean constant) {
        if (!particles && !sounds) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        float factor = (constant ? 1.0f : level.getRainLevel(1.0f)) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        Camera camera = minecraft.gameRenderer.getMainCamera();
        RandomSource randomSource = RandomSource.create((long)((long)ticks * 312987231L));
        BlockPos iPos = BlockPos.containing((Position)camera.getPosition());
        boolean effects = false;
        ParticleStatus particleStatus = (ParticleStatus)minecraft.options.particles().get();
        boolean visible = particleStatus != ParticleStatus.MINIMAL;
        int amount = (int)(100.0f * factor * factor) / (particleStatus == ParticleStatus.DECREASED ? 2 : 1);
        amount = (int)((float)amount * power);
        for (int i = 0; i < amount; ++i) {
            int iz;
            int ix = randomSource.nextInt((range << 1) + 1) - range;
            BlockPos surface = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, iPos.offset(ix, 0, iz = randomSource.nextInt((range << 1) + 1) - range));
            if (surface.getY() <= level.getMinBuildHeight() || surface.getY() > iPos.getY() + range || surface.getY() < iPos.getY() - range) continue;
            Biome.Precipitation precipitation = ((Biome)level.getBiome(surface).value()).getPrecipitationAt(surface);
            switch (target) {
                case 1: {
                    effects = precipitation == Biome.Precipitation.RAIN;
                    break;
                }
                case 2: {
                    effects = precipitation == Biome.Precipitation.SNOW;
                    break;
                }
                case 4: {
                    effects = precipitation == Biome.Precipitation.RAIN || precipitation == Biome.Precipitation.SNOW;
                    break;
                }
                case 8: {
                    effects = precipitation == Biome.Precipitation.NONE;
                    break;
                }
                case 16: {
                    effects = true;
                }
            }
            if (!effects) continue;
            BlockPos ground = surface.below();
            if (particles && visible) {
                double dx = randomSource.nextDouble();
                double dz = randomSource.nextDouble();
                BlockState blockState = level.getBlockState(ground);
                FluidState fluidState = level.getFluidState(ground);
                VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)level, ground);
                double maxHeight = Math.max(voxelShape.max(Direction.Axis.Y, dx, dz), (double)fluidState.getHeight((BlockGetter)level, ground));
                ParticleOptions particleOptions = !fluidState.is(FluidTags.LAVA) && !blockState.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockState) ? genericParticle : specialParticle;
                level.addParticle(particleOptions, (double)ground.getX() + dx, (double)ground.getY() + maxHeight, (double)ground.getZ() + dz, 0.0, 0.0, 0.0);
            }
            if (!sounds || i != 0 || ground == null || (ticks & 3) <= randomSource.nextInt(3)) continue;
            if (ground.getY() > iPos.getY() + 1 && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, iPos).getY() > Mth.floor((float)iPos.getY())) {
                level.playLocalSound(ground, specialSound, SoundSource.WEATHER, 0.1f, 0.5f, false);
                continue;
            }
            level.playLocalSound(ground, genericSound, SoundSource.WEATHER, 0.2f, 1.0f, false);
        }
    }

    @SubscribeEvent
    public static void effectsSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_EFFECTS").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute() {
        WeatherSoundsParticlesProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }
}

