/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModAttributes;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModBlockEntities;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModBlocks;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModEntities;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModFluidTypes;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModFluids;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModItems;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModMenus;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModMobEffects;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModParticleTypes;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModSounds;
import net.mcreator.cosmosinfinia.init.CosmosInfiniaModTabs;
import net.mcreator.cosmosinfinia.world.features.StructureFeature;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cosmos_infinia")
public class CosmosInfiniaMod {
    public static final Logger LOGGER = LogManager.getLogger(CosmosInfiniaMod.class);
    public static final String MODID = "cosmos_infinia";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("cosmos_infinia", "cosmos_infinia"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CosmosInfiniaMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CosmosInfiniaModSounds.REGISTRY.register(bus);
        CosmosInfiniaModBlocks.REGISTRY.register(bus);
        CosmosInfiniaModBlockEntities.REGISTRY.register(bus);
        CosmosInfiniaModItems.REGISTRY.register(bus);
        CosmosInfiniaModEntities.REGISTRY.register(bus);
        CosmosInfiniaModTabs.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        CosmosInfiniaModMobEffects.REGISTRY.register(bus);
        CosmosInfiniaModParticleTypes.REGISTRY.register(bus);
        CosmosInfiniaModMenus.REGISTRY.register(bus);
        CosmosInfiniaModFluids.REGISTRY.register(bus);
        CosmosInfiniaModFluidTypes.REGISTRY.register(bus);
        CosmosInfiniaModAttributes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

