/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.cosmosinfinia.CosmosInfiniaMod;
import net.mcreator.cosmosinfinia.procedures.GoAsteroidBeltProcedure;
import net.mcreator.cosmosinfinia.procedures.GoEOZProcedure;
import net.mcreator.cosmosinfinia.procedures.GoEarthProcedure;
import net.mcreator.cosmosinfinia.procedures.GoEuropaProcedure;
import net.mcreator.cosmosinfinia.procedures.GoMarsProcedure;
import net.mcreator.cosmosinfinia.procedures.GoMercuryProcedure;
import net.mcreator.cosmosinfinia.procedures.GoMoonProcedure;
import net.mcreator.cosmosinfinia.procedures.GoTitanProcedure;
import net.mcreator.cosmosinfinia.procedures.GoVenusProcedure;
import net.mcreator.cosmosinfinia.procedures.LaunchRocketProcedure;
import net.mcreator.cosmosinfinia.world.inventory.ChoosePlanetMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChoosePlanetButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ChoosePlanetButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ChoosePlanetButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ChoosePlanetButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ChoosePlanetButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ChoosePlanetButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ChoosePlanetMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GoEarthProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GoMoonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            GoMarsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GoAsteroidBeltProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GoVenusProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GoMercuryProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GoTitanProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            LaunchRocketProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            GoEOZProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            GoEuropaProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CosmosInfiniaMod.addNetworkMessage(ChoosePlanetButtonMessage.class, ChoosePlanetButtonMessage::buffer, ChoosePlanetButtonMessage::new, ChoosePlanetButtonMessage::handler);
    }
}

