/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.network;

import java.util.function.Supplier;
import net.mcreator.cosmosinfinia.CosmosInfiniaMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CosmosInfiniaModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CosmosInfiniaMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        CosmosInfiniaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.does_player_have_oxygen = message.data.does_player_have_oxygen;
                    variables.oxygen_in_tanks_transfer = message.data.oxygen_in_tanks_transfer;
                    variables.can_set_oxygen = message.data.can_set_oxygen;
                    variables.page_of_space_book = message.data.page_of_space_book;
                    variables.has_player_joined_yet = message.data.has_player_joined_yet;
                    variables.tier_of_rocket = message.data.tier_of_rocket;
                    variables.show_next_button = message.data.show_next_button;
                    variables.hovering = message.data.hovering;
                    variables.take_fall_dmg = message.data.take_fall_dmg;
                    variables.dashing = message.data.dashing;
                    variables.has_been_in_eoz = message.data.has_been_in_eoz;
                    variables.EOZ_Base_X = message.data.EOZ_Base_X;
                    variables.EOZ_Base_Z = message.data.EOZ_Base_Z;
                    variables.EOZ_Base_Y = message.data.EOZ_Base_Y;
                    variables.show_helmet_text = message.data.show_helmet_text;
                    variables.accelerant_level = message.data.accelerant_level;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean does_player_have_oxygen = true;
        public double oxygen_in_tanks_transfer = 0.0;
        public boolean can_set_oxygen = true;
        public double page_of_space_book = 0.0;
        public boolean has_player_joined_yet = false;
        public double tier_of_rocket = 0.0;
        public boolean show_next_button = false;
        public boolean hovering = false;
        public boolean take_fall_dmg = true;
        public boolean dashing = false;
        public boolean has_been_in_eoz = false;
        public double EOZ_Base_X = 0.0;
        public double EOZ_Base_Z = 0.0;
        public double EOZ_Base_Y = 0.0;
        public boolean show_helmet_text = true;
        public double accelerant_level = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CosmosInfiniaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("does_player_have_oxygen", this.does_player_have_oxygen);
            nbt.m_128347_("oxygen_in_tanks_transfer", this.oxygen_in_tanks_transfer);
            nbt.m_128379_("can_set_oxygen", this.can_set_oxygen);
            nbt.m_128347_("page_of_space_book", this.page_of_space_book);
            nbt.m_128379_("has_player_joined_yet", this.has_player_joined_yet);
            nbt.m_128347_("tier_of_rocket", this.tier_of_rocket);
            nbt.m_128379_("show_next_button", this.show_next_button);
            nbt.m_128379_("hovering", this.hovering);
            nbt.m_128379_("take_fall_dmg", this.take_fall_dmg);
            nbt.m_128379_("dashing", this.dashing);
            nbt.m_128379_("has_been_in_eoz", this.has_been_in_eoz);
            nbt.m_128347_("EOZ_Base_X", this.EOZ_Base_X);
            nbt.m_128347_("EOZ_Base_Z", this.EOZ_Base_Z);
            nbt.m_128347_("EOZ_Base_Y", this.EOZ_Base_Y);
            nbt.m_128379_("show_helmet_text", this.show_helmet_text);
            nbt.m_128347_("accelerant_level", this.accelerant_level);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.does_player_have_oxygen = nbt.m_128471_("does_player_have_oxygen");
            this.oxygen_in_tanks_transfer = nbt.m_128459_("oxygen_in_tanks_transfer");
            this.can_set_oxygen = nbt.m_128471_("can_set_oxygen");
            this.page_of_space_book = nbt.m_128459_("page_of_space_book");
            this.has_player_joined_yet = nbt.m_128471_("has_player_joined_yet");
            this.tier_of_rocket = nbt.m_128459_("tier_of_rocket");
            this.show_next_button = nbt.m_128471_("show_next_button");
            this.hovering = nbt.m_128471_("hovering");
            this.take_fall_dmg = nbt.m_128471_("take_fall_dmg");
            this.dashing = nbt.m_128471_("dashing");
            this.has_been_in_eoz = nbt.m_128471_("has_been_in_eoz");
            this.EOZ_Base_X = nbt.m_128459_("EOZ_Base_X");
            this.EOZ_Base_Z = nbt.m_128459_("EOZ_Base_Z");
            this.EOZ_Base_Y = nbt.m_128459_("EOZ_Base_Y");
            this.show_helmet_text = nbt.m_128471_("show_helmet_text");
            this.accelerant_level = nbt.m_128459_("accelerant_level");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cosmos_infinia", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "cosmos_infinia_mapvars";
        public double gravity = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.gravity = nbt.m_128459_("gravity");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("gravity", this.gravity);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CosmosInfiniaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "cosmos_infinia_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CosmosInfiniaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.does_player_have_oxygen = original.does_player_have_oxygen;
            clone.page_of_space_book = original.page_of_space_book;
            clone.has_player_joined_yet = original.has_player_joined_yet;
            clone.tier_of_rocket = original.tier_of_rocket;
            clone.show_next_button = original.show_next_button;
            clone.hovering = original.hovering;
            clone.take_fall_dmg = original.take_fall_dmg;
            clone.dashing = original.dashing;
            clone.has_been_in_eoz = original.has_been_in_eoz;
            clone.EOZ_Base_X = original.EOZ_Base_X;
            clone.EOZ_Base_Z = original.EOZ_Base_Z;
            clone.EOZ_Base_Y = original.EOZ_Base_Y;
            clone.show_helmet_text = original.show_helmet_text;
            clone.accelerant_level = original.accelerant_level;
            if (!event.isWasDeath()) {
                clone.oxygen_in_tanks_transfer = original.oxygen_in_tanks_transfer;
                clone.can_set_oxygen = original.can_set_oxygen;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CosmosInfiniaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CosmosInfiniaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CosmosInfiniaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

