/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.cosmosinfinia.CosmosInfiniaMod;
import net.mcreator.cosmosinfinia.procedures.CoreTunnelProcedure;
import net.mcreator.cosmosinfinia.procedures.PlaceGardenOrbProcedure;
import net.mcreator.cosmosinfinia.procedures.PlaceOrbProcedure;
import net.mcreator.cosmosinfinia.procedures.PlaceRocketRoomProcedure;
import net.mcreator.cosmosinfinia.procedures.PlaceTunnelHorizontalProcedure;
import net.mcreator.cosmosinfinia.procedures.SmallTunnelProcedure;
import net.mcreator.cosmosinfinia.world.inventory.SpaceStation2PlaceGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpaceStation2PlaceGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SpaceStation2PlaceGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SpaceStation2PlaceGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SpaceStation2PlaceGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SpaceStation2PlaceGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SpaceStation2PlaceGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SpaceStation2PlaceGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PlaceOrbProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            PlaceTunnelHorizontalProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            PlaceGardenOrbProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            SmallTunnelProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            CoreTunnelProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            PlaceRocketRoomProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CosmosInfiniaMod.addNetworkMessage(SpaceStation2PlaceGUIButtonMessage.class, SpaceStation2PlaceGUIButtonMessage::buffer, SpaceStation2PlaceGUIButtonMessage::new, SpaceStation2PlaceGUIButtonMessage::handler);
    }
}

