/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cosmosinfinia.procedures;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class WeatherSoundsParticlesProcedure {
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static ParticleOptions genericParticle = ParticleTypes.f_123761_;
    private static ParticleOptions specialParticle = ParticleTypes.f_123762_;
    private static SoundEvent genericSound = SoundEvents.f_12541_;
    private static SoundEvent specialSound = SoundEvents.f_12542_;
    private static final Predicate<Object[]> PREDICATE = params -> {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        partialTick = minecraft.getPartialTick();
        ticks = (Integer)params[1];
        if (entity != null) {
            ClientLevel level = minecraft.f_91073_;
            Vec3 pos = entity.m_20318_(partialTick);
            WeatherSoundsParticlesProcedure.execute(null);
            return true;
        }
        return false;
    };

    public static void setParticles(ParticleOptions genericParticle, ParticleOptions specialParticle) {
        WeatherSoundsParticlesProcedure.genericParticle = genericParticle;
        WeatherSoundsParticlesProcedure.specialParticle = specialParticle;
    }

    public static void setSounds(SoundEvent genericSound, SoundEvent specialSound) {
        WeatherSoundsParticlesProcedure.genericSound = genericSound;
        WeatherSoundsParticlesProcedure.specialSound = specialSound;
    }

    public static void addEffects(int target, float power, int range, boolean particles, boolean sounds, boolean constant) {
        if (!particles && !sounds) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        float factor = (constant ? 1.0f : level.m_46722_(1.0f)) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        Camera camera = minecraft.f_91063_.m_109153_();
        RandomSource randomSource = RandomSource.m_216335_((long)((long)ticks * 312987231L));
        BlockPos iPos = BlockPos.m_274446_((Position)camera.m_90583_());
        boolean effects = false;
        ParticleStatus particleStatus = (ParticleStatus)minecraft.f_91066_.m_231929_().m_231551_();
        boolean visible = particleStatus != ParticleStatus.MINIMAL;
        int amount = (int)(100.0f * factor * factor) / (particleStatus == ParticleStatus.DECREASED ? 2 : 1);
        amount = (int)((float)amount * power);
        for (int i = 0; i < amount; ++i) {
            int iz;
            int ix = randomSource.m_188503_((range << 1) + 1) - range;
            BlockPos surface = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, iPos.m_7918_(ix, 0, iz = randomSource.m_188503_((range << 1) + 1) - range));
            if (surface.m_123342_() <= level.m_141937_() || surface.m_123342_() > iPos.m_123342_() + range || surface.m_123342_() < iPos.m_123342_() - range) continue;
            Biome.Precipitation precipitation = ((Biome)level.m_204166_(surface).m_203334_()).m_264600_(surface);
            switch (target) {
                case 1: {
                    effects = precipitation == Biome.Precipitation.RAIN;
                    break;
                }
                case 2: {
                    effects = precipitation == Biome.Precipitation.SNOW;
                    break;
                }
                case 4: {
                    effects = precipitation == Biome.Precipitation.RAIN || precipitation == Biome.Precipitation.SNOW;
                    break;
                }
                case 8: {
                    effects = precipitation == Biome.Precipitation.NONE;
                    break;
                }
                case 16: {
                    effects = true;
                }
            }
            if (!effects) continue;
            BlockPos ground = surface.m_7495_();
            if (particles && visible) {
                double dx = randomSource.m_188500_();
                double dz = randomSource.m_188500_();
                BlockState blockState = level.m_8055_(ground);
                FluidState fluidState = level.m_6425_(ground);
                VoxelShape voxelShape = blockState.m_60812_((BlockGetter)level, ground);
                double maxHeight = Math.max(voxelShape.m_83290_(Direction.Axis.Y, dx, dz), (double)fluidState.m_76155_((BlockGetter)level, ground));
                ParticleOptions particleOptions = !fluidState.m_205070_(FluidTags.f_13132_) && !blockState.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockState) ? genericParticle : specialParticle;
                level.m_7106_(particleOptions, (double)ground.m_123341_() + dx, (double)ground.m_123342_() + maxHeight, (double)ground.m_123343_() + dz, 0.0, 0.0, 0.0);
            }
            if (!sounds || i != 0 || ground == null || (ticks & 3) <= randomSource.m_188503_(3)) continue;
            if (ground.m_123342_() > iPos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, iPos).m_123342_() > Mth.m_14143_((float)iPos.m_123342_())) {
                level.m_245747_(ground, specialSound, SoundSource.WEATHER, 0.1f, 0.5f, false);
                continue;
            }
            level.m_245747_(ground, genericSound, SoundSource.WEATHER, 0.2f, 1.0f, false);
        }
    }

    @SubscribeEvent
    public static void effectsSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_EFFECTS").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute() {
        WeatherSoundsParticlesProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }
}

