/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentinsights.client.gui.component;

import com.google.common.collect.ImmutableList;
import fuzs.enchantmentinsights.EnchantmentInsights;
import fuzs.enchantmentinsights.client.util.EnchantmentWithLevel;
import fuzs.enchantmentinsights.config.ClientConfig;
import fuzs.tooltipinsights.api.v1.client.gui.component.TooltipComponentExtractor;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class EnchantmentComponents {
    static final TooltipComponentExtractor<EnchantmentWithLevel, ItemEnchantments> ENCHANTMENTS = new TooltipComponentExtractor<EnchantmentWithLevel, ItemEnchantments>(DataComponents.ENCHANTMENTS){

        protected boolean isEnabled() {
            return ((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.itemDescriptionTargets.enchantments;
        }

        protected Stream<EnchantmentWithLevel> extractFromComponent(ItemEnchantments itemEnchantments) {
            return itemEnchantments.entrySet().stream().map(EnchantmentWithLevel::new);
        }
    };
    static final TooltipComponentExtractor<EnchantmentWithLevel, ItemEnchantments> STORED_ENCHANTMENTS = new TooltipComponentExtractor<EnchantmentWithLevel, ItemEnchantments>(DataComponents.STORED_ENCHANTMENTS){

        protected boolean isEnabled() {
            return ((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.itemDescriptionTargets.storedEnchantments;
        }

        protected Stream<EnchantmentWithLevel> extractFromComponent(ItemEnchantments itemEnchantments) {
            return itemEnchantments.entrySet().stream().map(EnchantmentWithLevel::new);
        }
    };
    private static final List<TooltipComponentExtractor<EnchantmentWithLevel, ?>> ENCHANTMENT_SUPPLIERS = ImmutableList.of(ENCHANTMENTS, STORED_ENCHANTMENTS);

    private EnchantmentComponents() {
    }

    public static Stream<EnchantmentWithLevel> getAllEnchantments(ItemStack itemStack) {
        return ENCHANTMENT_SUPPLIERS.stream().flatMap(supplier -> supplier.extractFromItemStack(itemStack));
    }
}

