/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentinsights.client.gui.tooltip;

import com.google.common.collect.ImmutableList;
import fuzs.enchantmentinsights.EnchantmentInsights;
import fuzs.enchantmentinsights.client.util.EnchantmentWithLevel;
import fuzs.enchantmentinsights.config.ClientConfig;
import fuzs.puzzleslib.api.init.v3.registry.ResourceKeyHelper;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.DescriptionLines;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.InternalNameLines;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.ModNameLines;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.TooltipLinesExtractor;
import fuzs.tooltipinsights.api.v1.config.AbstractClientConfig;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;

public final class EnchantmentTooltipLines {
    static final TooltipLinesExtractor<EnchantmentWithLevel, AbstractClientConfig.TooltipComponents> DESCRIPTION = new DescriptionLines<EnchantmentWithLevel>(){

        protected String getDescriptionId(EnchantmentWithLevel enchantmentWithLevel) {
            ResourceKey resourceKey = (ResourceKey)enchantmentWithLevel.enchantment().unwrapKey().orElseThrow();
            return ResourceKeyHelper.getTranslationKey((ResourceKey)resourceKey);
        }
    };
    static final TooltipLinesExtractor<EnchantmentWithLevel, ClientConfig.EnchantmentTooltipComponents> COMPATIBLE_ITEMS = new TooltipLinesExtractor<EnchantmentWithLevel, ClientConfig.EnchantmentTooltipComponents>(true){

        protected boolean isEnabled(ClientConfig.EnchantmentTooltipComponents tooltipComponents) {
            return tooltipComponents.compatibleItems;
        }

        protected Stream<Component> getTooltipLines(EnchantmentWithLevel enchantmentWithLevel) {
            Enchantment.EnchantmentDefinition enchantmentDefinition = ((Enchantment)enchantmentWithLevel.enchantment().value()).definition();
            Stream.Builder builder = Stream.builder();
            enchantmentDefinition.primaryItems().flatMap(HolderSet::unwrapKey).map(this::getTagKeyAsComponent).ifPresent(builder);
            enchantmentDefinition.supportedItems().unwrapKey().map(this::getTagKeyAsComponent).ifPresent(builder);
            return builder.build();
        }

        private Component getTagKeyAsComponent(TagKey<?> tagKey) {
            return Component.literal((String)("#" + String.valueOf(tagKey.location()))).withStyle(ChatFormatting.LIGHT_PURPLE);
        }
    };
    static final TooltipLinesExtractor<EnchantmentWithLevel, AbstractClientConfig.TooltipComponents> MOD_NAME = new ModNameLines<EnchantmentWithLevel>(){

        protected ResourceKey<?> getResourceKey(EnchantmentWithLevel enchantmentWithLevel) {
            return (ResourceKey)enchantmentWithLevel.enchantment().unwrapKey().orElseThrow();
        }
    };
    static final TooltipLinesExtractor<EnchantmentWithLevel, AbstractClientConfig.TooltipComponents> INTERNAL_NAME = new InternalNameLines<EnchantmentWithLevel>(){

        protected ResourceKey<?> getResourceKey(EnchantmentWithLevel enchantmentWithLevel) {
            return (ResourceKey)enchantmentWithLevel.enchantment().unwrapKey().orElseThrow();
        }
    };
    static final List<TooltipLinesExtractor<EnchantmentWithLevel, ClientConfig.EnchantmentTooltipComponents>> ENCHANTMENT_SUPPLIERS = ImmutableList.of((Object)DESCRIPTION.cast(), COMPATIBLE_ITEMS, (Object)MOD_NAME.cast(), (Object)INTERNAL_NAME.cast());

    private EnchantmentTooltipLines() {
    }

    public static List<Component> getEnchantmentItemTooltipLines(EnchantmentWithLevel enchantmentWithLevel) {
        return TooltipLinesExtractor.getTooltipLines(ENCHANTMENT_SUPPLIERS, (Component)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.decorationComponent, (Style)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.decorationStyle, (Object)enchantmentWithLevel, (AbstractClientConfig.TooltipComponents)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.itemTooltipLines);
    }

    public static List<Component> getEnchantmentTableTooltipLines(EnchantmentWithLevel enchantmentWithLevel) {
        return TooltipLinesExtractor.getTooltipLines(ENCHANTMENT_SUPPLIERS, (Component)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentTableTooltips.decorationComponent, (Style)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentTableTooltips.decorationStyle, (Object)enchantmentWithLevel, (AbstractClientConfig.TooltipComponents)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentTableTooltips.tableTooltipLines);
    }
}

