/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentinsights.client.handler;

import fuzs.enchantmentinsights.EnchantmentInsights;
import fuzs.enchantmentinsights.client.gui.component.EnchantmentComponents;
import fuzs.enchantmentinsights.client.gui.tooltip.EnchantmentTooltipLines;
import fuzs.enchantmentinsights.client.util.EnchantmentWithLevel;
import fuzs.enchantmentinsights.config.ClientConfig;
import fuzs.tooltipinsights.api.v1.client.handler.TooltipDescriptionsHandler;
import fuzs.tooltipinsights.api.v1.config.ItemDescriptionMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public final class EnchantmentItemTooltipHandler
extends TooltipDescriptionsHandler<EnchantmentWithLevel> {
    public static final TooltipDescriptionsHandler<EnchantmentWithLevel> INSTANCE = new EnchantmentItemTooltipHandler();

    private EnchantmentItemTooltipHandler() {
    }

    protected ItemDescriptionMode getItemDescriptionMode() {
        return ((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.itemDescriptions;
    }

    protected Map<String, EnchantmentWithLevel> getByDescriptionId(ItemStack itemStack, HolderLookup.Provider registries) {
        return EnchantmentItemTooltipHandler.getByDescriptionId(EnchantmentComponents.getAllEnchantments(itemStack));
    }

    static Map<String, EnchantmentWithLevel> getByDescriptionId(Stream<EnchantmentWithLevel> stream) {
        return stream.mapMulti((enchantmentWithLevel, consumer) -> {
            Component component = ((Enchantment)enchantmentWithLevel.enchantment().value()).description();
            ComponentContents patt0$temp = component.getContents();
            if (patt0$temp instanceof TranslatableContents) {
                TranslatableContents translatableContents = (TranslatableContents)patt0$temp;
                consumer.accept(Map.entry(translatableContents.getKey(), enchantmentWithLevel));
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
    }

    protected Component getValueComponent(EnchantmentWithLevel enchantmentWithLevel) {
        return EnchantmentItemTooltipHandler.getFullName(enchantmentWithLevel.enchantment(), enchantmentWithLevel.level());
    }

    protected List<Component> getItemTooltipLines(EnchantmentWithLevel enchantmentWithLevel) {
        return EnchantmentTooltipLines.getEnchantmentItemTooltipLines(enchantmentWithLevel);
    }

    public static Component getFullName(Holder<Enchantment> enchantment, int level) {
        MutableComponent mutableComponent = ((Enchantment)enchantment.value()).description().copy();
        EnchantmentItemTooltipHandler.mergeEnchantmentStyle(enchantment, mutableComponent);
        EnchantmentItemTooltipHandler.addLevelComponent(enchantment, level, mutableComponent);
        return mutableComponent;
    }

    private static void mergeEnchantmentStyle(Holder<Enchantment> enchantment, MutableComponent mutableComponent) {
        if (enchantment.is(EnchantmentTags.CURSE)) {
            ComponentUtils.mergeStyles((MutableComponent)mutableComponent, (Style)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.enchantmentNameStyling.curseStyle);
        } else if (enchantment.is(EnchantmentTags.TREASURE)) {
            ComponentUtils.mergeStyles((MutableComponent)mutableComponent, (Style)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.enchantmentNameStyling.treasureStyle);
        } else {
            ComponentUtils.mergeStyles((MutableComponent)mutableComponent, (Style)((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.enchantmentNameStyling.defaultStyle);
        }
    }

    private static void addLevelComponent(Holder<Enchantment> enchantment, int level, MutableComponent mutableComponent) {
        boolean maximumLevel = ((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.itemTooltipLines.maximumLevel();
        if (maximumLevel || level != 1 || ((Enchantment)enchantment.value()).getMaxLevel() != 1) {
            mutableComponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + level)));
            if (maximumLevel) {
                int maxLevel = ((Enchantment)enchantment.value()).getMaxLevel();
                mutableComponent.append(CommonComponents.SPACE).append("(").append((Component)Component.translatable((String)("enchantment.level." + maxLevel))).append(")");
            }
        }
    }
}

