/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentinsights.config;

import fuzs.enchantmentinsights.EnchantmentInsights;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import fuzs.tooltipinsights.api.v1.config.AbstractClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;

public class ClientConfig
extends AbstractClientConfig {
    @Config
    public final EnchantmentItemTooltips enchantmentItemTooltips = new EnchantmentItemTooltips();
    @Config
    public final EnchantmentTableTooltips enchantmentTableTooltips = new EnchantmentTableTooltips();

    public static class EnchantmentItemTooltips
    extends AbstractClientConfig.ItemTooltips {
        @Config
        public final EnchantmentDescriptionTargets itemDescriptionTargets = new EnchantmentDescriptionTargets();
        @Config
        public final EnchantmentLevelTooltipComponents itemTooltipLines = new EnchantmentLevelTooltipComponents();
        @Config
        public final EnchantmentTextStyling enchantmentNameStyling = new EnchantmentTextStyling();
    }

    public static class EnchantmentTableTooltips
    extends AbstractClientConfig.ItemTooltips {
        @Config
        public final EnchantmentTooltipComponents tableTooltipLines = new EnchantmentTooltipComponents();
    }

    public static class EnchantmentLevelTooltipComponents
    extends EnchantmentTooltipComponents {
        @Config(description={"Add the maximum enchantment level as part of the name to tooltips."})
        public boolean maximumLevel = true;

        public boolean maximumLevel() {
            return this.maximumLevel && ((ClientConfig)EnchantmentInsights.CONFIG.get(ClientConfig.class)).enchantmentItemTooltips.itemDescriptions.isActive();
        }
    }

    public static class EnchantmentTooltipComponents
    extends AbstractClientConfig.TooltipComponents {
        @Config(description={"Add tags for primary and other supported items to tooltips."})
        public boolean compatibleItems = true;
    }

    public static class EnchantmentTextStyling
    implements ConfigCore {
        @Config(description={"Formatting codes for setting custom text colors and styles for normal enchantments.", "https://minecraft.wiki/w/Formatting_codes"})
        String defaultFormatting = ComponentHelper.getAsString((Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN));
        @Config(description={"Formatting codes for setting custom text colors and styles for treasure enchantments.", "https://minecraft.wiki/w/Formatting_codes"})
        String treasureFormatting = ComponentHelper.getAsString((Style)Style.EMPTY.applyFormat(ChatFormatting.GOLD));
        @Config(description={"Formatting codes for setting custom text colors and styles for curses.", "https://minecraft.wiki/w/Formatting_codes"})
        String curseFormatting = ComponentHelper.getAsString((Style)Style.EMPTY.applyFormat(ChatFormatting.RED));
        public Style defaultStyle;
        public Style treasureStyle;
        public Style curseStyle;

        public void afterConfigReload() {
            this.defaultStyle = ComponentHelper.getDefaultStyle((String)this.defaultFormatting);
            this.treasureStyle = ComponentHelper.getDefaultStyle((String)this.treasureFormatting);
            this.curseStyle = ComponentHelper.getDefaultStyle((String)this.curseFormatting);
        }
    }

    public static class EnchantmentDescriptionTargets
    implements ConfigCore {
        @Config(description={"Add enchantment descriptions to enchanted items."})
        public boolean enchantments = true;
        @Config(description={"Add enchantment descriptions to enchanted books."})
        public boolean storedEnchantments = true;
    }
}

