/*
 * Decompiled with CFR 0.152.
 */
package com.sammcb.synthesizer.config;

import com.sammcb.synthesizer.Log;
import com.sammcb.synthesizer.block.enums.Tier;
import com.sammcb.synthesizer.config.ConfigData;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/sammcb/synthesizer/config/Config;", "", "<init>", "()V", "", "validateFileExists", "", "allow", "()Z", "", "delay", "()I", "Lnet/minecraft/class_1799;", "itemStack", "inList", "(Lnet/minecraft/class_1799;)Z", "Lcom/sammcb/synthesizer/block/enums/Tier;", "tier", "stackSize", "(Lcom/sammcb/synthesizer/block/enums/Tier;)I", "MIN_SIZE", "I", "MIN_DELAY", "", "CONFIG_FILE_NAME", "Ljava/lang/String;", "Lcom/sammcb/synthesizer/config/ConfigData;", "configData", "Lcom/sammcb/synthesizer/config/ConfigData;", "defaultConfig", "synthesizer"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ncom/sammcb/synthesizer/config/Config\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,93:1\n774#2:94\n865#2,2:95\n222#3:97\n*S KotlinDebug\n*F\n+ 1 Config.kt\ncom/sammcb/synthesizer/config/Config\n*L\n66#1:94\n66#1:95,2\n52#1:97\n*E\n"})
public final class Config {
    @NotNull
    public static final Config INSTANCE;
    private static final int MIN_SIZE = 1;
    private static final int MIN_DELAY = 0;
    @NotNull
    private static final String CONFIG_FILE_NAME = "synthesizer.json";
    @Nullable
    private static ConfigData configData;
    @NotNull
    private static final String defaultConfig = "{\n\t\"allow\": false,\n\t\"items\": [],\n\t\"tiers\": {\n\t\t\"wood\": 1,\n\t\t\"copper\": 4,\n\t\t\"iron\": 8,\n\t\t\"gold\": 16,\n\t\t\"diamond\": 32,\n\t\t\"netherite\": 64\n\t},\n\t\"delay\": 20\n}\n";

    private Config() {
    }

    public final void validateFileExists() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME).toFile();
        if (configFile.exists()) {
            return;
        }
        Log.INSTANCE.getLOGGER().warning("Config file synthesizer.json does not exist!");
    }

    public final boolean allow() {
        ConfigData configData = Config.configData;
        return configData != null ? configData.getAllow() : false;
    }

    public final int delay() {
        ConfigData configData = Config.configData;
        int n = configData != null ? configData.getDelay() : 20;
        int n2 = 0;
        return Math.max(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean inList(@NotNull class_1799 itemStack) {
        List list;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        String tagPrefix = "#";
        Object object = configData;
        if (object != null && (object = ((ConfigData)object).getItems()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)tagPrefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List tags = list;
        for (String tag : tags) {
            class_2960 tagId = class_2960.method_60656((String)StringsKt.removePrefix((String)tag, (CharSequence)tagPrefix));
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
            if (!itemStack.method_31573(tagKey)) continue;
            return true;
        }
        String string = itemStack.method_7909().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String itemId = string;
        Object object2 = configData;
        if (object2 == null || (object2 = ((ConfigData)object2).getItems()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object configItems = object2;
        return configItems.contains(itemId);
    }

    public final int stackSize(@NotNull Tier tier) {
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"tier");
        int defaultAmount = switch (WhenMappings.$EnumSwitchMapping$0[tier.ordinal()]) {
            case 1 -> 1;
            case 2 -> 4;
            case 3 -> 8;
            case 4 -> 16;
            case 5 -> 32;
            case 6 -> 64;
            default -> throw new NoWhenBranchMatchedException();
        };
        Object object = configData;
        if (object == null || (object = ((ConfigData)object).getTiers()) == null) {
            object = MapsKt.emptyMap();
        }
        Object tiers = object;
        int stackSize = ((Number)tiers.getOrDefault(tier.getLevel(), defaultAmount)).intValue();
        return Math.max(stackSize, 1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void this_$iv;
        INSTANCE = new Config();
        Path path = FabricLoader.getInstance().getConfigDir();
        File file = new File(path + "/synthesizer.json");
        boolean isNewFile = file.createNewFile();
        String jsonString = null;
        if (isNewFile) {
            FilesKt.writeText$default((File)file, (String)defaultConfig, null, (int)2, null);
            jsonString = defaultConfig;
        } else {
            jsonString = FilesKt.readText$default((File)file, null, (int)1, null);
        }
        Json json = (Json)Json.Default;
        String string$iv = jsonString;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        configData = (ConfigData)this_$iv.decodeFromString((DeserializationStrategy)ConfigData.Companion.serializer(), string$iv);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tier.values().length];
            try {
                nArray[Tier.WOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.COPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.IRON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.GOLD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.DIAMOND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.NETHERITE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

