import json
import os

# --- Your Pokémon data ---
pokemon_data = {
    "Charmander": { "temperature": 25, "range": 10 },
    "Charmeleon": { "temperature": 30, "range": 10 },
    "Charizard": { "temperature": 35, "range": 10 },
    
    "Growlithe": { "temperature": 25, "range": 10 },
    "Arcanine": { "temperature": 35, "range": 10 },
    "Ponyta": { "temperature": 25, "range": 10 },
    "Rapidash": { "temperature": 35, "range": 10 },
    "Magby": { "temperature": 25, "range": 10 },
    "Magmar": { "temperature": 30, "range": 10 },
    "Magmortar": { "temperature": 35, "range": 10 },
    "Flareon": { "temperature": 35, "range": 10 },
    
    "Cyndaquil": { "temperature": 35, "range": 10 },
    "Quilava": { "temperature": 35, "range": 10 },
    "Typhlosion": { "temperature": 35, "range": 10 },
    
    "Slugma": { "temperature": 30, "range": 10 },
    "Magcargo": { "temperature": 30, "range": 10 },
    "Houndour": { "temperature": 25, "range": 10 },
    "Houndoom": { "temperature": 30, "range": 10 },
    "Moltres": { "temperature": 35, "range": 10 },
    "Ho-Oh": { "temperature": 35, "range": 10 },
    "Entei": { "temperature": 35, "range": 10 },
    
    "Torchic": { "temperature": 25, "range": 10 },
    "Combusken": { "temperature": 30, "range": 10 },
    "Blaziken": { "temperature": 35, "range": 10 },
    
    "Numel": { "temperature": 25, "range": 10 },
    "Camerupt": { "temperature": 30, "range": 10 },
    "Torkoal": { "temperature": 35, "range": 10 },

    "Chimchar": { "temperature": 25, "range": 10 },
    "Monferno": { "temperature": 30, "range": 10 },
    "Infernape": { "temperature": 35, "range": 10 },

    "Heatran": { "temperature": 35, "range": 10 },
    
    "Tepig": {"temperature": 25,"range": 10},
    "Pignite": {"temperature": 30,"range": 10},
    "Emboar": {"temperature": 35,"range": 10},
    
    "Darumaka": { "temperature": 25, "range": 10 },
    "Pansear": { "temperature": 25, "range": 10 },
    "Simisear": { "temperature": 30, "range": 10 },

    "Heatmor": { "temperature": 30, "range": 10 },

    "Darmanitan": { "temperature": 25, "range": 10 },

    "Victini": { "temperature": 35, "range": 10 },

    "Litwick": { "temperature": 25, "range": 10 },
    "Lampent": { "temperature": 30, "range": 10 },
    "Chandelure": { "temperature": 35, "range": 10 },

    "Larvesta": { "temperature": 25, "range": 10 },
    "Volcarona": { "temperature": 30, "range": 10 },
    
    "Fennekin": { "temperature": 25, "range": 10 },
    "Braixen": { "temperature": 30, "range": 10 },
    "Delphox": { "temperature": 35, "range": 10 },
    
    "Fletchling": { "temperature": 25, "range": 10 },
    "Fletchinder": { "temperature": 30, "range": 10 },
    "Talonflame": { "temperature": 35, "range": 10 },
    "Litleo": { "temperature": 25, "range": 10 },
    "Pyroar": { "temperature": 30, "range": 10 },
    "Volcanion": { "temperature": 35, "range": 10 },
    
    "Litten": { "temperature": 25, "range": 10 },
    "Torracat": { "temperature": 30, "range": 10 },
    "Incineroar": { "temperature": 35, "range": 10 },
    
    "Salandit": { "temperature": 25, "range": 10 },
    "Salazzle": { "temperature": 30, "range": 10 },
    "Turtonator": { "temperature": 35, "range": 10 },
    "Carkol": { "temperature": 35, "range": 10 },
    "Coalossal": { "temperature": 35, "range": 10 },
    
    "Scorbunny": { "temperature": 25, "range": 10 },
    "Raboot": { "temperature": 30, "range": 10 },
    "Cinderace": { "temperature": 35, "range": 10 },
    
    "Sizzlipede": { "temperature": 30, "range": 10 },
    "Centiskorch": { "temperature": 30, "range": 10 },
    "Iron Moth": { "temperature": 30, "range": 10 },
    
    "Fuecoco": { "temperature": 25, "range": 10 },
    "Crocalor": { "temperature": 30, "range": 10 },
    "Skeledirge": { "temperature": 35, "range": 10 },
    
    "Charcadet": { "temperature": 35, "range": 10 },
    "Armarouge": { "temperature": 35, "range": 10 },
    
    "Articuno": {"temperature": -20.0,"range": 10},
    "Regice": {"temperature": -20.0,"range": 10},
    "Suicune": {"temperature": -20.0,"range": 10},
    "Snorunt": {"temperature": -10.0,"range": 10},
    "Glalie": {"temperature": -20.0,"range": 10},
    "Regice": {"temperature": -20.0,"range": 10},
    "Froslass": {"temperature": -20.0,"range": 10},
    "Abomasnow": {"temperature": -20.0,"range": 10},
    "Vanillite": {"temperature": -10.0,"range": 10},
    "Vanillish": {"temperature": -20.0,"range": 10},
    "Vanilluxe": {"temperature": -20.0,"range": 10},
    "Cubchoo": {"temperature": -10.0,"range": 10},
    "Beartic": {"temperature": -20.0,"range": 10},
    "Cryogonal": {"temperature": -20.0,"range": 10},
    "Bergmite": {"temperature": -10.0,"range": 10},
    "Avalugg": {"temperature": -20.0,"range": 10},
    "Spheal": {"temperature": -10.0,"range": 10},
    "Sealo": {"temperature": -20.0,"range": 10},
    "Walrein": {"temperature": -20.0,"range": 10},
    "Glaceon": {"temperature": -20.0,"range": 10},
    "Kyurem": {"temperature": -20.0,"range": 10},
    "Aurorus": {"temperature": -20.0,"range": 10},
    "Eiscue": {"temperature": -20.0,"range": 10},
    "Beartic": {"temperature": -20.0,"range": 10},
    "Cetoddle": {"temperature": -20.0,"range": 10},
    "Cetitan": {"temperature": -20.0,"range": 10},
    "Frosmoth": {"temperature": -20.0,"range": 10}
    
}

# --- Output directory ---
output_dir = "pokemon_files"
os.makedirs(output_dir, exist_ok=True)

# --- Generate JSON files ---
for name, values in pokemon_data.items():
    # sanitize the name for filenames + species ids
    safe_name = name.lower().replace(" ", "").replace("-", "").replace("'", "")

    data = {
        "required_mods": ["cobblemon"],
        "entity": {
            "entities": ["cobblemon:pokemon"],
            "nbt": {
                "Pokemon": {
                    "Species": f"cobblemon:{safe_name}"
                }
            }
        },
        "temperature": float(values["temperature"]),
        "units": "c",
        "range": float(values["range"]),
        "affects_self": True
    }

    # Save each file (e.g., charmander.json)
    filename = os.path.join(output_dir, f"{safe_name}.json")
    with open(filename, "w", encoding="utf-8") as f:
        json.dump(data, f, indent=4)

print(f"Generated {len(pokemon_data)} files in '{output_dir}/'")
