/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.lootsentinel;

import com.everydayxp.lootsentinel.config.LootSentinelConfig;
import com.everydayxp.lootsentinel.util.SummonDetectionHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lootsentinel")
public class ChestBlockHandler {
    @SubscribeEvent
    public static void onProtectedBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        boolean nowTargeted;
        boolean isTargeted;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        BlockState state = level.m_8055_(pos);
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockId == null || !((List)LootSentinelConfig.protectedBlocks.get()).contains(blockId.toString())) {
            return;
        }
        int radius = (Integer)LootSentinelConfig.detectionRadius.get();
        int height = (Integer)LootSentinelConfig.verticalDetectionHeight.get();
        AABB detectionBox = new AABB((double)(pos.m_123341_() - radius), (double)pos.m_123342_(), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius + 1), (double)(pos.m_123342_() + height + 1), (double)(pos.m_123343_() + radius + 1));
        List nearbyMobs = level.m_6443_(Mob.class, detectionBox, mob -> {
            TamableAnimal tamable;
            if (!(mob instanceof Enemy) || !mob.m_6084_()) {
                return false;
            }
            if (mob instanceof TamableAnimal && (tamable = (TamableAnimal)mob).m_21824_() && tamable.m_269323_() instanceof Player) {
                return false;
            }
            if (SummonDetectionHelper.isSafeSummon(mob)) {
                return false;
            }
            String entityId = mob.m_6095_().toString();
            return !((List)LootSentinelConfig.excludedEntityTypes.get()).contains(entityId);
        });
        if (((Boolean)LootSentinelConfig.enableGlowingEffect.get()).booleanValue()) {
            for (Object mob2 : nearbyMobs) {
                mob2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60, 0));
            }
        }
        if (!(isTargeted = nearbyMobs.stream().anyMatch(mob -> mob.m_5448_() == player)) && !nearbyMobs.isEmpty()) {
            for (Mob mob3 : nearbyMobs) {
                mob3.m_6710_((LivingEntity)player);
            }
        }
        if (nowTargeted = nearbyMobs.stream().anyMatch(mob -> mob.m_5448_() == player)) {
            if (!level.f_46443_ && ((Boolean)LootSentinelConfig.enableBlockMessages.get()).booleanValue()) {
                String[] variants = new String[]{"message.lootsentinel.chest_blocked_variant1", "message.lootsentinel.chest_blocked_variant2", "message.lootsentinel.chest_blocked_variant3", "message.lootsentinel.chest_blocked_variant4", "message.lootsentinel.chest_blocked_variant5"};
                String chosenKey = variants[level.m_213780_().m_188503_(variants.length)];
                MutableComponent message = Component.m_237115_((String)chosenKey).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                player.m_5661_((Component)message, true);
            }
            event.setCanceled(true);
        }
    }
}

