/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.lootsentinel;

import com.everydayxp.lootsentinel.util.SummonDetectionHelper;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lootsentinel")
public class ChestBlockHandler {
    private static final Set<ResourceLocation> CHEST_BLOCKS = Set.of(new ResourceLocation("minecraft", "chest"), new ResourceLocation("minecraft", "barrel"), new ResourceLocation("minecraft", "shulker_box"), new ResourceLocation("lootr", "lootr_chest"), new ResourceLocation("lootr", "lootr_barrel"), new ResourceLocation("lootr", "lootr_shulker_box"));
    private static final String[] BLOCKED_MESSAGES = new String[]{"message.lootsentinel.chest_blocked_variant1", "message.lootsentinel.chest_blocked_variant2", "message.lootsentinel.chest_blocked_variant3", "message.lootsentinel.chest_blocked_variant4", "message.lootsentinel.chest_blocked_variant5"};
    private static final String[] INVISIBLE_MESSAGES = new String[]{"message.lootsentinel.chest_open_invisible_variant1", "message.lootsentinel.chest_open_invisible_variant2", "message.lootsentinel.chest_open_invisible_variant3", "message.lootsentinel.chest_open_invisible_variant4", "message.lootsentinel.chest_open_invisible_variant5"};

    @SubscribeEvent
    public static void onChestOpen(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos = event.getPos());
        ResourceLocation blockId = state.m_60734_().m_204297_().m_205785_().m_135782_();
        if (CHEST_BLOCKS.contains(blockId)) {
            AABB searchBox = new AABB((double)(pos.m_123341_() - 8), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 8), (double)(pos.m_123341_() + 8), (double)(pos.m_123342_() + 3), (double)(pos.m_123343_() + 8));
            List nearbyEnemies = level.m_45976_(Monster.class, searchBox);
            for (Monster enemy : nearbyEnemies) {
                if (SummonDetectionHelper.isSafeSummon((Mob)enemy)) continue;
                enemy.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0));
            }
            if (player.m_21023_(MobEffects.f_19609_)) {
                if (!level.f_46443_) {
                    int index = ThreadLocalRandom.current().nextInt(INVISIBLE_MESSAGES.length);
                    String chosenKey = INVISIBLE_MESSAGES[index];
                    player.m_5661_((Component)Component.m_237115_((String)chosenKey), true);
                }
                return;
            }
            boolean hasRealEnemies = nearbyEnemies.stream().anyMatch(mob -> !SummonDetectionHelper.isSafeSummon((Mob)mob));
            if (hasRealEnemies) {
                event.setCanceled(true);
                if (!level.f_46443_) {
                    int index = ThreadLocalRandom.current().nextInt(BLOCKED_MESSAGES.length);
                    String chosenKey = BLOCKED_MESSAGES[index];
                    player.m_5661_((Component)Component.m_237115_((String)chosenKey), true);
                }
                for (Monster enemy : nearbyEnemies) {
                    if (SummonDetectionHelper.isSafeSummon((Mob)enemy)) continue;
                    enemy.m_6710_((LivingEntity)player);
                    enemy.m_6598_(player);
                    enemy.m_6469_(level.m_269111_().m_269075_(player), 0.0f);
                }
            }
        }
    }
}

