/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.lootsentinel.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class LootSentinelConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.IntValue detectionRadius;
    public static final ForgeConfigSpec.IntValue verticalDetectionHeight;
    public static final ForgeConfigSpec.BooleanValue enableGlowingEffect;
    public static final ForgeConfigSpec.BooleanValue enableBlockMessages;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> protectedBlocks;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> excludedEntityTypes;

    static {
        detectionRadius = BUILDER.comment("Enemy detection radius around protected blocks (horizontal)").defineInRange("detectionRadius", 8, 1, 32);
        verticalDetectionHeight = BUILDER.comment("Vertical detection height above the protected block").defineInRange("verticalDetectionHeight", 3, 1, 16);
        enableGlowingEffect = BUILDER.comment("If true, enemies near protected blocks will glow when detected").define("enableGlowingEffect", true);
        enableBlockMessages = BUILDER.comment("If true, players will see a message when a chest is blocked").define("enableBlockMessages", true);
        protectedBlocks = BUILDER.comment("List of block IDs that should be protected by Loot Sentinel").defineListAllowEmpty("protectedBlocks", List.of("minecraft:chest", "minecraft:barrel", "minecraft:shulker_box", "lootr:lootr_chest", "lootr:lootr_barrel", "lootr:lootr_shulker_box"), obj -> obj instanceof String);
        excludedEntityTypes = BUILDER.comment("List of entity type IDs to exclude from detection (e.g. 'minecraft:vex', 'ars_nouveau:familiar')").defineListAllowEmpty("excludedEntityTypes", List.of(), obj -> obj instanceof String);
        CONFIG = BUILDER.build();
    }
}

