/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.antiquelegacy.item.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TinOreBlock
extends Block {
    private final IntProvider xpRange = UniformInt.of((int)2, (int)5);

    public TinOreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack tool, boolean dropExperience) {
        super.spawnAfterBreak(state, level, pos, tool, dropExperience);
        if (dropExperience) {
            this.tryDropExperience(level, pos, tool, this.xpRange);
        }
    }

    protected void tryDropExperience(ServerLevel level, BlockPos pos, ItemStack tool, IntProvider xpRange) {
        int xpAmount;
        if (xpRange != null && (xpAmount = xpRange.sample(level.random)) > 0) {
            ExperienceOrb.award((ServerLevel)level, (Vec3)pos.getCenter(), (int)xpAmount);
        }
    }
}

