/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.antiquelegacy.misc;

import com.magistuarmory.antiquelegacy.item.AddonItems;
import com.magistuarmory.antiquelegacy.util.AddonEquipments;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;

public class AddonCreativeTabs {
    public static final ResourceKey<CreativeModeTab> PARTICULAR_WEAPONS_RESOURCE_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"particular_weapons"));
    public static final ResourceKey<CreativeModeTab> ARMOR_RESOURCE_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"armor"));
    public static final ResourceKey<CreativeModeTab> ARMOR_DECORATIONS_RESOURCE_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"armor_decorations"));
    public static final ResourceKey<CreativeModeTab> INGRIDIENTS_RESOURCE_KEY = CreativeModeTabs.INGREDIENTS;
    public static final ResourceKey<CreativeModeTab> NATURAL_BLOCKS_RESOURCE_KEY = CreativeModeTabs.NATURAL_BLOCKS;

    public static void init() {
        for (RegistrySupplier item : AddonItems.INSTANCE.weaponItems) {
            if (item != AddonItems.WEATHERED_EAGLE_STANDARD) {
                AddonCreativeTabs.append(PARTICULAR_WEAPONS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
                continue;
            }
            CreativeTabRegistry.appendStack(PARTICULAR_WEAPONS_RESOURCE_KEY, AddonEquipments::getWeatheredEagleStandardItem);
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.shieldItems) {
            AddonCreativeTabs.append(PARTICULAR_WEAPONS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.armorItems) {
            AddonCreativeTabs.append(ARMOR_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.armorDecorationItems) {
            AddonCreativeTabs.append(ARMOR_DECORATIONS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.ingredientItems) {
            AddonCreativeTabs.append(INGRIDIENTS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        AddonCreativeTabs.append(NATURAL_BLOCKS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{AddonItems.TIN_ORE});
        AddonCreativeTabs.append(NATURAL_BLOCKS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{AddonItems.DEEPSLATE_TIN_ORE});
    }

    @SafeVarargs
    public static <I extends ItemLike, T extends Supplier<I>> void append(ResourceKey<CreativeModeTab> tab, T ... items) {
        Arrays.stream(items).filter(Objects::nonNull).forEach(item -> CreativeTabRegistry.append((ResourceKey)tab, (Supplier[])new Supplier[]{item}));
    }
}

