/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.velocityLimboHandler.auth.handlers;

import com.akselglyholt.velocityLimboHandler.VelocityLimboHandler;
import com.akselglyholt.velocityLimboHandler.auth.AuthHandler;
import com.akselglyholt.velocityLimboHandler.libs.route.Route;
import com.akselglyholt.velocityLimboHandler.misc.ReconnectBlocker;
import com.akselglyholt.velocityLimboHandler.storage.PlayerManager;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class LibreLoginHandler
implements AuthHandler {
    private final ProxyServer proxy;
    private final ReconnectBlocker blocker;
    private volatile boolean active;
    private final Logger logger = VelocityLimboHandler.getLogger();
    private final PlayerManager playerManager = VelocityLimboHandler.getPlayerManager();
    private final long timeoutSeconds = VelocityLimboHandler.getConfig().getInt("auth-timeout-seconds", (Integer)120).intValue();

    public LibreLoginHandler(ProxyServer proxy, ReconnectBlocker blocker) {
        this.proxy = proxy;
        this.blocker = blocker;
        this.active = proxy.getPluginManager().getPlugin("librelogin").isPresent() || LibreLoginHandler.classPresent("xyz.kyngs.librelogin.api.LibreLoginPlugin");
        this.logger.info("LibreLogin plugin detected! Integrating now");
        if (this.active) {
            this.tryHook();
        }
    }

    @Override
    public String name() {
        return "LibreLogin";
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void onPlayerJoin(Player player) {
        if (!this.active) {
            return;
        }
        this.blocker.block(player.getUniqueId(), "auth");
        if (this.timeoutSeconds <= 0L) {
            return;
        }
        this.proxy.getScheduler().buildTask((Object)VelocityLimboHandler.getInstance(), () -> {
            if (this.blocker.isBlocked(player.getUniqueId())) {
                player.disconnect(MiniMessage.miniMessage().deserialize((Object)VelocityLimboHandler.getMessageConfig().getString(Route.from((Object)"authTimeout"))));
                player.disconnect(MiniMessage.miniMessage().deserialize((Object)"<red>Authentication timed out. Please rejoin.</red>"));
                this.blocker.unblock(player.getUniqueId());
            }
        }).delay(Duration.ofSeconds(this.timeoutSeconds)).schedule();
    }

    private void tryHook() {
        try {
            Optional containerOpt = this.proxy.getPluginManager().getPlugin("librelogin");
            Optional instanceOpt = containerOpt.flatMap(PluginContainer::getInstance);
            if (instanceOpt.isEmpty()) {
                this.logger.warning("LibreLogin plugin instance not available.");
                return;
            }
            Object bootstrap = instanceOpt.get();
            Method getLibreLogin = bootstrap.getClass().getMethod("getLibreLogin", new Class[0]);
            Object core = getLibreLogin.invoke(bootstrap, new Object[0]);
            Method getEventProvider = core.getClass().getMethod("getEventProvider", new Class[0]);
            Object eventProvider = getEventProvider.invoke(core, new Object[0]);
            Method getTypes = eventProvider.getClass().getMethod("getTypes", new Class[0]);
            Object types = getTypes.invoke(eventProvider, new Object[0]);
            for (Field f : types.getClass().getFields()) {
                try {
                    Object object = f.get(types);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            Field authField = types.getClass().getField("authenticated");
            Object authType = authField.get(types);
            Class<?> eventTypeClass = Class.forName("xyz.kyngs.librelogin.api.event.EventType");
            Method subscribe = eventProvider.getClass().getMethod("subscribe", eventTypeClass, Consumer.class);
            Consumer<Object> handler = event -> {
                try {
                    Player p = this.extractPlayerFromLibreEvent(event);
                    if (p != null) {
                        this.logger.info("Player " + p.getUsername() + " authenticated via LibreLogin \u2014 unblocked.");
                        this.blocker.unblock(p.getUniqueId());
                        RegisteredServer server = this.playerManager.getPreviousServer(p);
                        this.playerManager.addPlayer(p, server);
                    } else {
                        Method getUuid;
                        Object user;
                        Method getUser = LibreLoginHandler.safeMethod(event.getClass(), "getUser", new Class[0]);
                        if (getUser != null && (user = getUser.invoke(event, new Object[0])) != null && (getUuid = LibreLoginHandler.safeMethod(user.getClass(), "getUuid", new Class[0])) != null) {
                            Object uuid = getUuid.invoke(user, new Object[0]);
                            this.blocker.unblock((UUID)uuid);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.warning("Failed to process LibreLogin auth event: " + ex.getMessage());
                }
            };
            subscribe.invoke(eventProvider, authType, handler);
            this.logger.info("Subscribed to LibreLogin 'authenticated' event.");
        }
        catch (Exception e) {
            this.logger.warning("Failed to integrate with LibreLogin: " + e.getMessage());
        }
    }

    private static Method safeMethod(Class<?> c, String name, Class<?> ... params) {
        try {
            return c.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Player extractPlayerFromLibreEvent(Object event) {
        try {
            Object user;
            Object p;
            Method getPlayer = LibreLoginHandler.safeMethod(event.getClass(), "getPlayer", new Class[0]);
            if (getPlayer != null && (p = getPlayer.invoke(event, new Object[0])) instanceof Player) {
                return (Player)p;
            }
            Method getUser = LibreLoginHandler.safeMethod(event.getClass(), "getUser", new Class[0]);
            if (getUser != null && (user = getUser.invoke(event, new Object[0])) != null) {
                Object p2;
                Object p3;
                Method proxyPlayer = LibreLoginHandler.safeMethod(user.getClass(), "getProxyPlayer", new Class[0]);
                if (proxyPlayer != null && (p3 = proxyPlayer.invoke(user, new Object[0])) instanceof Player) {
                    return (Player)p3;
                }
                Method getPlayer2 = LibreLoginHandler.safeMethod(user.getClass(), "getPlayer", new Class[0]);
                if (getPlayer2 != null && (p2 = getPlayer2.invoke(user, new Object[0])) instanceof Player) {
                    return (Player)p2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void onShutdown() {
    }

    private static boolean classPresent(String fqn) {
        try {
            Class.forName(fqn, false, LibreLoginHandler.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

