/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.bossscoretoggle;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.spunkyinsaan.bossscoretoggle.BossScoreToggle;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class BossScoreToggleClient
implements ClientModInitializer {
    private static boolean bossbarVisible = true;
    private static boolean scoreboardVisible = true;
    private static File configFile;
    private static final SuggestionProvider<FabricClientCommandSource> ON_OFF_SUGGESTIONS;

    public void onInitializeClient() {
        BossScoreToggle.LOGGER.info("Boss Score Toggle Client initialized!");
        this.initConfig();
        this.loadSettings();
        this.registerScoreboardHiding();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bossbar").then(ClientCommandManager.literal((String)"toggle").then(ClientCommandManager.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests(ON_OFF_SUGGESTIONS).executes(context -> {
                String state = StringArgumentType.getString((CommandContext)context, (String)"state");
                if ("on".equalsIgnoreCase(state)) {
                    BossScoreToggleClient.setBossbarVisible(true);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Bossbar turned ON"));
                } else if ("off".equalsIgnoreCase(state)) {
                    BossScoreToggleClient.setBossbarVisible(false);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Bossbar turned OFF"));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Use 'on' or 'off'"));
                    return 0;
                }
                this.saveSettings();
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"scoreboard").then(ClientCommandManager.literal((String)"toggle").then(ClientCommandManager.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests(ON_OFF_SUGGESTIONS).executes(context -> {
                String state = StringArgumentType.getString((CommandContext)context, (String)"state");
                if ("on".equalsIgnoreCase(state)) {
                    BossScoreToggleClient.setScoreboardVisible(true);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Scoreboard turned ON"));
                } else if ("off".equalsIgnoreCase(state)) {
                    BossScoreToggleClient.setScoreboardVisible(false);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Scoreboard turned OFF"));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Use 'on' or 'off'"));
                    return 0;
                }
                this.saveSettings();
                return 1;
            }))));
        });
    }

    private void initConfig() {
        class_310 client = class_310.method_1551();
        File configDir = new File(client.field_1697, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        configFile = new File(configDir, "boss-score-toggle.properties");
    }

    private void loadSettings() {
        if (!configFile.exists()) {
            return;
        }
        Properties props = new Properties();
        try (FileReader reader = new FileReader(configFile);){
            props.load(reader);
            bossbarVisible = Boolean.parseBoolean(props.getProperty("bossbar.visible", "true"));
            scoreboardVisible = Boolean.parseBoolean(props.getProperty("scoreboard.visible", "true"));
            BossScoreToggle.LOGGER.info("Loaded settings: Bossbar={}, Scoreboard={}", (Object)bossbarVisible, (Object)scoreboardVisible);
        }
        catch (IOException e) {
            BossScoreToggle.LOGGER.warn("Failed to load settings: {}", (Object)e.getMessage());
        }
    }

    private void saveSettings() {
        Properties props = new Properties();
        props.setProperty("bossbar.visible", String.valueOf(bossbarVisible));
        props.setProperty("scoreboard.visible", String.valueOf(scoreboardVisible));
        try (FileWriter writer = new FileWriter(configFile);){
            props.store(writer, "Boss Score Toggle Settings");
            BossScoreToggle.LOGGER.info("Saved settings: Bossbar={}, Scoreboard={}", (Object)bossbarVisible, (Object)scoreboardVisible);
        }
        catch (IOException e) {
            BossScoreToggle.LOGGER.error("Failed to save settings: {}", (Object)e.getMessage());
        }
    }

    public static boolean isBossbarVisible() {
        return bossbarVisible;
    }

    public static void setBossbarVisible(boolean visible) {
        bossbarVisible = visible;
    }

    public static boolean isScoreboardVisible() {
        return scoreboardVisible;
    }

    public static void setScoreboardVisible(boolean visible) {
        scoreboardVisible = visible;
    }

    private void registerScoreboardHiding() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_310 client;
            if (!scoreboardVisible && (client = class_310.method_1551()) != null && client.field_1687 != null && client.field_1724 != null) {
                this.hideScoreboardElements(client);
            }
        });
    }

    private void hideScoreboardElements(class_310 client) {
    }

    static {
        ON_OFF_SUGGESTIONS = (context, builder) -> {
            builder.suggest("on");
            builder.suggest("off");
            return builder.buildFuture();
        };
    }
}

