/*
 * Decompiled with CFR 0.152.
 */
package better_gold_equipment.procedures;

import better_gold_equipment.configuration.ConfigConfiguration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class TooltipsProcedure {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        TooltipsProcedure.execute((Event)event, event.getItemStack(), event.getToolTip());
    }

    public static void execute(ItemStack itemstack, List<Component> tooltip) {
        TooltipsProcedure.execute(null, itemstack, tooltip);
    }

    private static void execute(@Nullable Event event, ItemStack itemstack, List<Component> tooltip) {
        if (tooltip == null) {
            return;
        }
        if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"better_gold_equipment:golden_equipment"))) && Screen.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)"\u00a78Press [\u00a7fSHIFT\u00a78] for more info"));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)"\u00a77Better Gold Equipment:"));
            if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"better_gold_equipment:golden_equipment/tool")))) {
                if (((String)ConfigConfiguration.MINING_LEVEL.get()).equals("stone")) {
                    tooltip.add((Component)Component.literal((String)" \u00a72Stone Mining Level"));
                } else if (((String)ConfigConfiguration.MINING_LEVEL.get()).equals("iron")) {
                    tooltip.add((Component)Component.literal((String)" \u00a72Iron Mining Level"));
                } else {
                    tooltip.add((Component)Component.literal((String)" \u00a72Wood Mining Level \u00a78(vanilla default)"));
                }
                if ((Double)ConfigConfiguration.TOOL_REPAIR_RATE.get() != 0.0) {
                    tooltip.add((Component)Component.literal((String)" \u00a72Auto-Repair \u00a78(regains durability when held)"));
                    tooltip.add((Component)Component.literal((String)(" \u00a72" + Math.round(Math.min(72000.0, Math.max((Double)ConfigConfiguration.TOOL_REPAIR_RATE.get(), 20.0))) + " Repair Rate \u00a78(in ticks)")));
                }
            } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"better_gold_equipment:golden_equipment/armor"))) && (Double)ConfigConfiguration.ARMOR_REPAIR_RATE.get() != 0.0) {
                tooltip.add((Component)Component.literal((String)" \u00a72Auto-Repair \u00a78(regains durability when worn)"));
                tooltip.add((Component)Component.literal((String)(" \u00a72" + Math.round(Math.min(72000.0, Math.max((Double)ConfigConfiguration.ARMOR_REPAIR_RATE.get(), 20.0))) + " Repair Rate \u00a78(in ticks)")));
            }
        } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"better_gold_equipment:golden_equipment"))) && !Screen.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)"\u00a78Press [\u00a77SHIFT\u00a78] for more info"));
        }
    }
}

