/*
 * Decompiled with CFR 0.152.
 */
package com.ms.plugins;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class App
extends JavaPlugin {
    private final Map<UUID, Integer> warnings = new HashMap<UUID, Integer>();

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration cfg = this.getConfig();
        List worlds = cfg.getStringList("worlds");
        HashSet activeWorlds = new HashSet(worlds);
        String reportCommand = cfg.getString("report-command", "report %player% utilizzo della fullbright in %world%");
        Server server = this.getServer();
        ConsoleCommandSender consoleSender = Bukkit.getConsoleSender();
        server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            for (World world : server.getWorlds()) {
                if (!activeWorlds.contains(world.getName())) continue;
                for (Player player : world.getPlayers()) {
                    int count;
                    boolean holdingTorch;
                    if (player.getGameMode() != GameMode.SURVIVAL) continue;
                    Location location = player.getLocation();
                    PlayerInventory inventory = player.getInventory();
                    UUID playerId = player.getUniqueId();
                    boolean isDark = location.getBlock().getLightLevel() < 2 && location.getY() < 40.0;
                    boolean hasVision = player.hasPotionEffect(PotionEffectType.NIGHT_VISION) || player.hasPotionEffect(PotionEffectType.GLOWING);
                    boolean bl = holdingTorch = inventory.getItemInMainHand().getType() == Material.TORCH || inventory.getItemInOffHand().getType() == Material.TORCH;
                    if (isDark && !hasVision && !holdingTorch) {
                        count = this.warnings.getOrDefault(playerId, 0) + 1;
                        if (count >= 5) {
                            String cmd = reportCommand.replace("%player%", player.getName()).replace("%world%", world.getName());
                            server.dispatchCommand((CommandSender)consoleSender, cmd);
                            this.warnings.remove(playerId);
                            continue;
                        }
                        this.warnings.put(playerId, count);
                        continue;
                    }
                    if (!this.warnings.containsKey(playerId)) continue;
                    count = this.warnings.get(playerId) - 1;
                    if (count <= 0) {
                        this.warnings.remove(playerId);
                        continue;
                    }
                    this.warnings.put(playerId, count);
                }
            }
        }, 200L, 200L);
    }

    public void onDisable() {
        this.warnings.clear();
    }
}

