#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

// Boost saturation
vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);

    // Handle transparent parts
#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif

    color *= vertexColor * ColorModulator;

    // Color overlay for damage
#ifndef NO_OVERLAY
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
#endif

    // Apply lighting
#ifndef EMISSIVE
    color *= lightMapColor;
#endif

    // Cel shading
    float brightness = max(max(color.r, color.g), color.b);
    float celLevels = 4.0;
    brightness = floor(brightness * celLevels) / celLevels;
    color.rgb = mix(color.rgb, vec3(brightness), 0.6);

    // Brighter entities
    color.rgb *= 1.4;

    // Vivid colors
    color.rgb = boostSaturation(color.rgb, 1.5);

    // Warm tint
    color.rgb *= vec3(1.1, 1.0, 0.9);

    color.rgb = clamp(color.rgb, 0.0, 1.0);

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}

