#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec2 texCoord0;
in vec4 vertexColor;

out vec4 fragColor;

vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    color *= vertexColor * ColorModulator;

    // Skip nearly invisible particles
    if (color.a < 0.1) {
        discard;
    }

    // Particle cel shading - keep them bright
    float brightness = max(max(color.r, color.g), color.b);
    float celLevels = 3.0;
    brightness = floor(brightness * celLevels) / celLevels;
    color.rgb = mix(color.rgb, vec3(brightness), 0.5);

    // Make particles pop
    color.rgb *= 1.5;
    color.rgb = boostSaturation(color.rgb, 1.8);

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}

