#version 150

in vec4 vertexColor;
uniform vec4 ColorModulator;

out vec4 fragColor;

// Sky color boost
vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = vertexColor;
    
    if (color.a == 0.0) {
        discard;
    }

    // Sky cel shading
    float brightness = max(max(color.r, color.g), color.b);
    float celLevels = 5.0;
    brightness = floor(brightness * celLevels) / celLevels;
    color.rgb = vec3(brightness);

    // Sky enhancement
    color.rgb *= 1.2;
    color.rgb = boostSaturation(color.rgb, 1.3);

    // Sky tint
    vec3 skyTint = vec3(0.9, 0.8, 1.0);
    color.rgb *= skyTint;

    fragColor = color * ColorModulator;
}

