#version 150

#moj_import <minecraft:fog.glsl>

uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;

out vec4 fragColor;

// Cloud saturation boost
vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = vertexColor;

    // Cel shading for clouds
    float brightness = max(max(color.r, color.g), color.b);
    float celLevels = 3.0;
    brightness = floor(brightness * celLevels) / celLevels;
    color.rgb = vec3(brightness);

    // Brighten clouds
    color.rgb *= 1.3;
    color.rgb = boostSaturation(color.rgb, 1.4);

    // Apply fog
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
 
 