#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

// Make colors pop more
vec3 makeColorsVibrant(vec3 color, float strength) {
    float avg = (color.r + color.g + color.b) / 3.0;
    float maxVal = max(max(color.r, color.g), color.b);
    float boost = (maxVal - avg) * 2.0;
    float vibrance = (1.0 - boost) * strength;
    vec3 gray = vec3(avg);
    return clamp(mix(gray, color, 1.0 + vibrance), 0.0, 1.0);
}

// Boost saturation
vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    color *= vertexColor * ColorModulator;

    // Handle transparency
#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif

    // Cel shading - cartoon look
    float brightness = max(max(color.r, color.g), color.b);
    float celLevels = 4.0;
    brightness = floor(brightness * celLevels) / celLevels;
    color.rgb = mix(color.rgb, vec3(brightness), 0.7);

    // Make brighter
    color.rgb *= 1.4;

    // More vivid colors
    color.rgb = boostSaturation(color.rgb, 1.5);

    // Slight warm tint
    color.rgb *= vec3(1.1, 1.0, 0.9);

    color.rgb = clamp(color.rgb, 0.0, 1.0);
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}

// Cel Shading Implementation
