#version 330 core

#import <sodium:include/fog.glsl>

in vec4 v_Color;
in vec2 v_TexCoord;
in float v_FragDistance;
in float v_MaterialMipBias;
in float v_MaterialAlphaCutoff;

uniform sampler2D u_BlockTex;
uniform vec4 u_FogColor;
uniform float u_FogStart;
uniform float u_FogEnd;

out vec4 fragColor;

vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 diffuseColor = texture(u_BlockTex, v_TexCoord, v_MaterialMipBias);
    diffuseColor *= v_Color;

#ifdef USE_FRAGMENT_DISCARD
    if (diffuseColor.a < v_MaterialAlphaCutoff) {
        discard;
    }
#endif

    // Block cel shading
    float brightness = max(max(diffuseColor.r, diffuseColor.g), diffuseColor.b);
    float celLevels = 4.0;
    brightness = floor(brightness * celLevels) / celLevels;
    diffuseColor.rgb = mix(diffuseColor.rgb, vec3(brightness), 0.7);

    // Make blocks pop
    diffuseColor.rgb *= 1.4;
    diffuseColor.rgb = boostSaturation(diffuseColor.rgb, 1.5);

    fragColor = _linearFog(diffuseColor, v_FragDistance, u_FogColor, u_FogStart, u_FogEnd);
}


