/*
 * Decompiled with CFR 0.152.
 */
package io.github.madis0;

import io.github.madis0.ClientProperties;
import io.github.madis0.ModConfig;
import io.github.madis0.PlayerProperties;
import me.shedaniel.autoconfig.AutoConfig;

public class MixinConfigQuery {
    private static final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();

    public static boolean isOneBarEnabled() {
        return MixinConfigQuery.config.showOneBar;
    }

    public static boolean isCompatModeEnabled() {
        return MixinConfigQuery.config.compatibilityMode;
    }

    public static boolean isHotbarTooltipsDown() {
        return MixinConfigQuery.config.otherBars.hotbarTooltipsDown;
    }

    public static boolean showMountJump() {
        return MixinConfigQuery.config.entity.showMountJump;
    }

    public static boolean isLocatorBarEnabled() {
        return MixinConfigQuery.config.otherBars.locatorBarMode != ModConfig.LocatorBarMode.DISABLED.ordinal() && PlayerProperties.locatorBarAvailable || MixinConfigQuery.isCompatModeEnabled();
    }

    public static boolean isLocatorBarMode(ModConfig.LocatorBarMode mode) {
        return MixinConfigQuery.config.otherBars.locatorBarMode == mode.ordinal();
    }

    public static int getLocatorBarHeight() {
        ModConfig.LocatorBarMode modeEnum;
        ClientProperties clientProperties = new ClientProperties();
        try {
            modeEnum = ModConfig.LocatorBarMode.values()[MixinConfigQuery.config.otherBars.locatorBarMode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            modeEnum = ModConfig.LocatorBarMode.DISABLED;
        }
        return switch (modeEnum) {
            case ModConfig.LocatorBarMode.HOTBAR -> clientProperties.locatorBarOriginalH;
            case ModConfig.LocatorBarMode.BOSSBAR -> clientProperties.locatorBarBossBarH;
            default -> 0;
        };
    }
}

