/*
 * Decompiled with CFR 0.152.
 */
package io.github.madis0;

import io.github.madis0.Calculations;
import io.github.madis0.ClientProperties;
import io.github.madis0.ModConfig;
import io.github.madis0.PlayerProperties;
import java.util.Locale;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_7689;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class OneBarElements {
    private final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    private final ClientProperties clientProperties = new ClientProperties();
    private final PlayerProperties playerProperties = new PlayerProperties();
    private final class_310 client = class_310.method_1551();
    private final class_1267 difficulty = Objects.requireNonNull(this.client.method_1560()).method_73183().method_8407();
    private final class_332 drawContext;
    private final class_327 textRenderer;
    private static final boolean hasExordium = FabricLoader.getInstance().isModLoaded("exordium");
    boolean hasHunger;
    float armorBarGap;
    float armorBarChestplateLength;
    float armorBarLeggingsLength;
    float armorBarBootsLength;
    float armorBarTotalLength;
    float elytraDurability;

    public OneBarElements(class_332 context) {
        this.textRenderer = this.client.field_1772;
        this.hasHunger = this.playerProperties.hasHunger && !this.config.disableHunger;
        this.armorBarGap = 0.1f;
        this.armorBarChestplateLength = this.armorBarGap + (float)this.playerProperties.helmetMaxArmor;
        this.armorBarLeggingsLength = this.armorBarChestplateLength + this.armorBarGap + (float)this.playerProperties.chestplateMaxArmor;
        this.armorBarBootsLength = this.armorBarLeggingsLength + this.armorBarGap + (float)this.playerProperties.leggingsMaxArmor;
        this.armorBarTotalLength = this.armorBarBootsLength + (float)this.playerProperties.bootsMaxArmor;
        this.elytraDurability = this.playerProperties.getArmorElementDurability((class_1657)Objects.requireNonNull(this.client.field_1724), class_1304.field_6174, 8.0f);
        this.drawContext = context;
    }

    public void renderOneBar() {
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity != null) {
            this.barBackground();
            if (this.config.healthEstimates && !this.config.uhcMode) {
                this.naturalRegenerationBar();
            }
            if (this.config.healthEstimates) {
                this.regenerationBar();
            }
            this.healthBar();
            if (this.config.healthEstimates) {
                this.poisonBar();
                this.witherBar();
                this.hungerEffectBar();
            }
            this.hungerBar();
            if (this.config.goodThings.heldFoodHungerBar) {
                this.heldFoodHungerBar();
            }
            if (this.config.badThings.showWarden) {
                this.wardenBar();
            }
            if (this.config.badThings.showFire) {
                this.fireBar();
            }
            if (this.config.badThings.showLevitation) {
                this.levitationBar();
            }
            this.freezeBar();
            this.airBar();
            this.xpBar();
            this.barText();
            if (this.config.armor.showArmorBar) {
                this.armorBar();
            }
            if (this.config.armor.showArmorDurabilityBar) {
                this.armorDurabilityBar();
            }
            if (this.config.armor.showElytraDurabilityBar) {
                this.elytraDurabilityBar();
            }
            if (this.config.armor.showShieldDurabilityBar) {
                this.shieldDurabilityBar();
            }
            if (this.config.armor.showShieldCooldownBar) {
                this.shieldCooldownBar();
            }
            if (this.config.goodThings.showSaturationBar) {
                this.saturationBar();
            }
        }
    }

    private void renderBar(int x1, int y1, int x2, int y2, int color) {
        if (!this.config.enableGradient) {
            this.drawContext.method_25294(x1, y1, x2, y2, color);
        } else {
            this.drawContext.method_25296(x1, y1, x2, y2, color, Calculations.manipulateColor(color, this.config.gradientShift));
        }
    }

    private void renderLeftToRightBar(float currentValue, float maxValue, int color) {
        this.renderBar(this.clientProperties.baseStartW, this.clientProperties.baseStartH, this.clientProperties.baseRelativeEndW(currentValue, maxValue), this.clientProperties.baseEndH, color);
    }

    private void renderLeftToRightBar(float currentValue, float maxValue, int color, int startH, int endH) {
        this.renderBar(this.clientProperties.baseStartW, startH, this.clientProperties.baseRelativeEndW(currentValue, maxValue), endH, color);
    }

    private void renderRightToLeftBar(float currentValue, float maxValue, int color) {
        this.renderBar(this.clientProperties.baseRelativeStartW(currentValue, maxValue), this.clientProperties.baseStartH, this.clientProperties.baseEndW, this.clientProperties.baseEndH, color);
    }

    private void renderRightToLeftBar(float currentValue, float maxValue, int color, int startH, int endH) {
        this.renderBar(this.clientProperties.baseRelativeStartW(currentValue, maxValue), startH, this.clientProperties.baseEndW, endH, color);
    }

    private void renderLeftToRightBarWithOffset(float offset, float currentValue, float totalLength, int color, int startH, int endH) {
        this.renderBar(this.clientProperties.baseRelativeEndW(offset, totalLength), startH, this.clientProperties.baseRelativeEndW(offset + currentValue, totalLength), endH, color);
    }

    private void renderRightToLeftBarMiddle(float leftValue, float rightValue, float maxValue, int color) {
        this.renderBar(this.clientProperties.baseRelativeStartW(leftValue, maxValue), this.clientProperties.baseStartH, this.clientProperties.baseRelativeEndW(rightValue, maxValue), this.clientProperties.baseEndH, color);
    }

    private void renderLeftToRightBarMiddle(float leftValue, float rightValue, float maxValue, int color, int startH, int endH) {
        float endValue = leftValue < rightValue ? rightValue : leftValue + rightValue;
        this.renderBar(this.clientProperties.baseRelativeEndW(leftValue, maxValue), startH, this.clientProperties.baseRelativeEndW(endValue, maxValue), endH, color);
    }

    private void barBackground() {
        this.renderBar(this.clientProperties.baseStartW, this.clientProperties.baseStartH, this.clientProperties.baseEndW, this.clientProperties.baseEndH, this.config.backgroundColor);
    }

    private void armorBar() {
        if (!this.config.armor.showSegmentedArmorBar) {
            this.renderLeftToRightBar(this.playerProperties.armor, this.playerProperties.maxArmor, this.config.armor.armorColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        } else {
            this.renderLeftToRightBar(this.playerProperties.helmetArmor, this.armorBarTotalLength, this.config.armor.armorColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            if (!this.playerProperties.hasElytra) {
                this.renderLeftToRightBarWithOffset(this.armorBarChestplateLength, this.playerProperties.chestplateArmor, this.armorBarTotalLength, this.config.armor.armorColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            } else if (this.config.armor.showElytraDurabilityBar && !this.config.armor.showArmorDurabilityBar) {
                this.renderLeftToRightBarWithOffset(this.armorBarChestplateLength, this.elytraDurability, this.armorBarTotalLength, this.config.armor.elytraDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            }
            this.renderLeftToRightBarWithOffset(this.armorBarLeggingsLength, this.playerProperties.leggingsArmor, this.armorBarTotalLength, this.config.armor.armorColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            this.renderLeftToRightBarWithOffset(this.armorBarBootsLength, this.playerProperties.bootsArmor, this.armorBarTotalLength, this.config.armor.armorColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        }
    }

    private void armorDurabilityBar() {
        if (this.client.field_1724 == null) {
            return;
        }
        float helmetDurability = this.playerProperties.getArmorElementDurability((class_1657)this.client.field_1724, class_1304.field_6169, this.playerProperties.helmetArmor);
        float chestplateDurability = this.playerProperties.getArmorElementDurability((class_1657)this.client.field_1724, class_1304.field_6174, this.playerProperties.chestplateArmor);
        float leggingsDurability = this.playerProperties.getArmorElementDurability((class_1657)this.client.field_1724, class_1304.field_6172, this.playerProperties.leggingsArmor);
        float bootsDurability = this.playerProperties.getArmorElementDurability((class_1657)this.client.field_1724, class_1304.field_6166, this.playerProperties.bootsArmor);
        if (!this.config.armor.showSegmentedArmorBar) {
            if (this.playerProperties.maxArmorDurability > 0.0f) {
                this.renderLeftToRightBar(this.playerProperties.armorDurability, this.playerProperties.maxArmor, this.config.armor.armorDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            }
        } else {
            this.renderLeftToRightBar(helmetDurability, this.armorBarTotalLength, this.config.armor.armorDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            if (!this.playerProperties.hasElytra) {
                this.renderLeftToRightBarWithOffset(this.armorBarChestplateLength, chestplateDurability, this.armorBarTotalLength, this.config.armor.armorDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            } else if (this.config.armor.showElytraDurabilityBar) {
                this.renderLeftToRightBarWithOffset(this.armorBarChestplateLength, this.elytraDurability, this.armorBarTotalLength, this.config.armor.elytraDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            }
            this.renderLeftToRightBarWithOffset(this.armorBarLeggingsLength, leggingsDurability, this.armorBarTotalLength, this.config.armor.armorDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
            this.renderLeftToRightBarWithOffset(this.armorBarBootsLength, bootsDurability, this.armorBarTotalLength, this.config.armor.armorDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        }
    }

    private void elytraDurabilityBar() {
        if (this.playerProperties.isFlyingWithElytra && !this.config.armor.showSegmentedArmorBar) {
            this.renderLeftToRightBar(this.playerProperties.elytraDurability, this.playerProperties.elytraMaxDurability, this.config.armor.elytraDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        }
    }

    private void shieldDurabilityBar() {
        if (this.playerProperties.usesShield) {
            this.renderLeftToRightBar(this.playerProperties.shieldDurability, this.playerProperties.shieldMaxDurability, this.config.armor.shieldDurabilityColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        }
    }

    private void shieldCooldownBar() {
        if (this.playerProperties.shieldRaiseTicksRemaining > 0.0f) {
            this.renderLeftToRightBar(this.playerProperties.shieldDurability, this.playerProperties.shieldMaxDurability, this.config.armor.shieldCooldownColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        } else if (this.playerProperties.shieldAxedCooldown > 0.0f) {
            this.renderLeftToRightBar(this.playerProperties.shieldAxedCooldown, this.playerProperties.shieldAxedMaxCooldown, this.config.armor.shieldCooldownColor, this.clientProperties.armorStartH, this.clientProperties.armorEndH);
        }
    }

    private void saturationBar() {
        this.renderLeftToRightBar(this.playerProperties.saturationRaw, this.playerProperties.maxFoodLevelRaw, this.config.goodThings.saturationColor, this.clientProperties.saturationStartH, this.clientProperties.saturationEndH);
    }

    private void heldFoodHungerBar() {
        if (this.hasHunger) {
            if (this.playerProperties.heldFoodHungerEstimate >= 0) {
                this.renderRightToLeftBarMiddle(this.playerProperties.hunger, this.playerProperties.maxFoodLevel - this.playerProperties.heldFoodHungerEstimate, this.playerProperties.maxFoodLevel, this.config.goodThings.heldFoodHungerGoodColor);
            } else {
                this.renderRightToLeftBar(this.playerProperties.heldFoodHunger, this.playerProperties.maxFoodLevel, this.config.goodThings.heldFoodHungerWasteColor);
            }
        }
    }

    private void heldFoodSaturationBar() {
        this.renderLeftToRightBar(this.playerProperties.heldFoodSaturationEstimateRaw, this.playerProperties.maxFoodLevelRaw, this.config.goodThings.heldFoodHungerGoodColor, this.clientProperties.saturationStartH, this.clientProperties.saturationEndH);
    }

    private void heldFoodHealthBar() {
        if (this.playerProperties.heldFoodHealthEstimateRaw > this.playerProperties.healthRaw) {
            this.renderLeftToRightBar(Math.max(this.playerProperties.heldFoodHealthEstimateRaw, this.playerProperties.healthRaw), this.playerProperties.maxHealthRaw, this.config.goodThings.naturalRegenerationColor);
        }
    }

    private void naturalRegenerationBar() {
        if (this.playerProperties.naturalRegenerationHealthRaw > this.playerProperties.healthRaw) {
            this.renderLeftToRightBar(Math.max(this.playerProperties.naturalRegenerationHealth, this.playerProperties.health), this.playerProperties.maxHealthRaw, this.config.goodThings.naturalRegenerationColor);
        }
    }

    private void regenerationBar() {
        if (this.playerProperties.hasRegeneration) {
            this.renderLeftToRightBar(Math.max(this.playerProperties.regenerationHealthRaw, this.playerProperties.healthRaw), this.playerProperties.maxHealthRaw, this.config.goodThings.regenerationColor);
        }
    }

    private void healthBar() {
        this.renderLeftToRightBar(this.playerProperties.healthRaw, this.playerProperties.maxHealthRaw, this.config.goodThings.healthColor);
    }

    private void poisonBar() {
        this.renderRightToLeftBar(this.playerProperties.maxHealthRaw - this.playerProperties.poisonHealthRaw, this.playerProperties.maxHealthRaw, this.config.badThings.poisonColor);
    }

    private void witherBar() {
        this.renderRightToLeftBar(this.playerProperties.maxHealthRaw - this.playerProperties.witherHealthRaw, this.playerProperties.maxHealthRaw, this.config.badThings.witherColor);
    }

    private void wardenBar() {
        this.renderRightToLeftBar(this.playerProperties.rawWardenDanger, this.playerProperties.rawMaxWardenDanger, this.config.badThings.wardenColor);
    }

    private void hungerEffectBar() {
        if (this.playerProperties.hungerEffectEstimateRaw > (float)this.playerProperties.hunger && !this.difficulty.equals((Object)class_1267.field_5801) && !this.config.disableHunger) {
            this.renderRightToLeftBar(this.playerProperties.hungerEffectEstimateRaw, this.playerProperties.maxFoodLevelRaw, this.config.badThings.hungerEffectColor);
        }
    }

    private void hungerBar() {
        if (this.hasHunger) {
            this.renderRightToLeftBar(this.playerProperties.hungerRaw, this.playerProperties.maxFoodLevelRaw, this.config.badThings.hungerColor);
        }
    }

    private void airBar() {
        this.renderRightToLeftBar(this.playerProperties.airRaw, this.playerProperties.maxAirRaw, this.config.badThings.airColor);
    }

    private void freezeBar() {
        this.renderRightToLeftBar(this.playerProperties.freezeRaw, this.playerProperties.maxFreezeRaw, this.config.badThings.freezeColor);
    }

    private void levitationBar() {
        this.renderRightToLeftBar(this.playerProperties.levitationTimeRaw, this.playerProperties.maxLevitationTimeRaw, this.config.badThings.levitationColor);
    }

    private void fireBar() {
        if (this.playerProperties.isBurning && !this.playerProperties.hasFireResistance) {
            this.renderRightToLeftBar(this.playerProperties.maxHealthRaw - this.playerProperties.healthRaw + (float)this.playerProperties.burningMultiplier, this.playerProperties.maxHealthRaw, this.config.badThings.fireColor);
        }
    }

    private void barText() {
        if (this.client.field_1724 == null) {
            return;
        }
        Object value = "";
        boolean showHealthParentheses = this.config.textSettings.estimatesParentheses && ((this.hasHunger || this.playerProperties.hasHungerEffect && !this.config.disableHunger || this.playerProperties.isUnderwater || this.playerProperties.isFreezing || this.playerProperties.isBurning || this.playerProperties.hasAbsorption || this.playerProperties.hasResistance && this.config.goodThings.showResistance) && (this.playerProperties.naturalRegenerationHealth > this.playerProperties.health && !this.config.uhcMode || this.playerProperties.hasRegeneration || this.playerProperties.isStarving && !this.config.disableHunger || this.playerProperties.hasPoison || this.playerProperties.hasWither || this.playerProperties.isGettingFreezeDamage || this.playerProperties.isBurningOnFire || this.playerProperties.isDrowning || this.playerProperties.isSuffocating) || this.playerProperties.levitationFallHurts && this.playerProperties.hasLevitation && this.config.badThings.showFallHeight || this.playerProperties.normalFallHurts && !this.playerProperties.hasLevitation && this.config.badThings.showFallHeight);
        boolean showHungerParentheses = this.config.textSettings.estimatesParentheses && this.config.healthEstimates && (this.playerProperties.hasHungerEffect && !this.config.disableHunger || this.hasHunger && this.playerProperties.isHoldingFood && this.config.goodThings.heldFoodHungerBar);
        String arrowRight = class_2561.method_43471((String)"text.onebar.healthEstimateEmoji").getString();
        String plus = "+";
        String minus = "-";
        String para = "\u00a7";
        String pStart = "(";
        String pEnd = ")";
        if (this.config.textSettings.showText) {
            if (this.config.healthEstimates && showHealthParentheses) {
                value = (String)value + "(";
            }
            value = (String)value + Calculations.emojiOrText("text.onebar.healthEmoji", "text.onebar.health", true, this.config.textSettings.rawHealth ? Double.valueOf((double)Math.round((double)this.playerProperties.healthRaw * 100.0) / 100.0) : Calculations.makeFraction(this.playerProperties.health, false));
            if (this.config.healthEstimates) {
                if (this.playerProperties.naturalRegenerationHealth > this.playerProperties.health && !this.config.uhcMode) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.naturalRegenerationHealth, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.levitationFallHurts && this.playerProperties.hasLevitation && this.config.badThings.showFallHeight) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.levitationFallHealthEstimate, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.normalFallHurts && !this.playerProperties.hasLevitation && this.config.badThings.showFallHeight) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.normalFallHealthEstimate, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.hasRegeneration) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.regenerationHealth, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.isStarving && this.hasHunger) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.starvationHealthEstimate, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.hasPoison) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.poisonHealth, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.hasWither) {
                    value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.witherHealth, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.isWardenAngry) {
                    value = (String)value + arrowRight + Calculations.makeFraction(0, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.isGettingFreezeDamage) {
                    value = (String)value + arrowRight + Calculations.makeFraction(0, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.isBurningOnFire) {
                    value = (String)value + arrowRight + Calculations.makeFraction(0, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.isDrowning) {
                    value = (String)value + arrowRight + Calculations.makeFraction(0, this.config.textSettings.estimatesItalic);
                }
                if (this.playerProperties.isSuffocating) {
                    value = (String)value + arrowRight + Calculations.makeFraction(0, this.config.textSettings.estimatesItalic);
                }
                if (showHealthParentheses) {
                    value = (String)value + ")";
                }
            }
        }
        if (this.playerProperties.hasAbsorption) {
            value = (String)value + "+" + Calculations.emojiOrText("text.onebar.absorptionEmoji", "text.onebar.absorption", true, Calculations.makeFraction(this.playerProperties.absorption, false));
        }
        if (this.config.textSettings.showText) {
            if (this.playerProperties.hasResistance && this.config.goodThings.showResistance) {
                value = (String)value + "+" + Calculations.emojiOrText("text.onebar.resistanceEmoji", "text.onebar.resistance", false, this.playerProperties.resistancePercent);
            }
            if (PlayerProperties.getMobHead((class_1657)this.client.field_1724) != null && this.config.armor.showMobHeads) {
                value = (String)value + "+" + PlayerProperties.getMobHead((class_1657)this.client.field_1724);
            }
            if (this.playerProperties.hasInvisibility && !this.playerProperties.hasAnyArmorItem && !this.playerProperties.hasArrowsStuck && !this.playerProperties.hasGlowing && this.config.goodThings.showInvisibility) {
                value = (String)value + "+" + Calculations.emojiOrText("text.onebar.invisibilityEmoji", "text.onebar.invisibility", false, new Object[]{null});
            }
            if (this.playerProperties.hasInvisibility && (this.playerProperties.hasAnyArmorItem || this.playerProperties.hasArrowsStuck || this.playerProperties.hasGlowing) && this.config.goodThings.showInvisibility) {
                value = (String)value + "+\u00a7m" + Calculations.emojiOrText("text.onebar.invisibilityEmoji", "text.onebar.invisibility", false, new Object[]{null}) + "\u00a7r";
            }
            if (this.playerProperties.hasTotemOfUndying && this.playerProperties.isHoldingTotemOfUndying && this.config.goodThings.showTotemOfUndying) {
                value = (String)value + "+" + Calculations.emojiOrText("text.onebar.totemOfUndyingEmoji", "text.onebar.totemOfUndying", false, this.playerProperties.amountTotemOfUndying);
            }
            if (this.playerProperties.hasTotemOfUndying && !this.playerProperties.isHoldingTotemOfUndying && this.config.goodThings.showTotemOfUndying) {
                value = (String)value + "+\u00a7m" + Calculations.emojiOrText("text.onebar.totemOfUndyingEmoji", "text.onebar.totemOfUndying", false, this.playerProperties.amountTotemOfUndying) + "\u00a7r";
            }
            if (this.playerProperties.isWardenNear && this.config.badThings.showWarden) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.wardenEmoji", "text.onebar.warden", false, Calculations.makeFraction(this.playerProperties.wardenDanger, false));
            }
            if (this.playerProperties.isUnderwater && !this.playerProperties.hasWaterBreathing) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.airEmoji", "text.onebar.air", false, Calculations.makeFraction(this.playerProperties.air, false));
            }
            if (this.playerProperties.isUnderwater && this.playerProperties.hasWaterBreathing) {
                value = (String)value + "-\u00a7m" + Calculations.emojiOrText("text.onebar.airEmoji", "text.onebar.air", false, Calculations.makeFraction(this.playerProperties.air, false)) + "\u00a7r";
            }
            if (this.playerProperties.isFreezing) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.freezeEmoji", "text.onebar.freeze", false, Calculations.makeFraction(this.playerProperties.freeze, false));
            }
            if (this.playerProperties.isBurning && !this.playerProperties.hasFireResistance && this.config.badThings.showFire) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.fireEmoji", "text.onebar.fire", false, this.playerProperties.burningMultiplier);
            }
            if (this.playerProperties.isBurning && this.playerProperties.hasFireResistance && this.config.badThings.showFire) {
                value = (String)value + "-\u00a7m" + Calculations.emojiOrText("text.onebar.fireEmoji", "text.onebar.fire", false, this.playerProperties.burningMultiplier) + "\u00a7r";
            }
            if (this.playerProperties.hasLevitation && !this.playerProperties.isInWater && this.config.badThings.showLevitation) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.levitationEmoji", "text.onebar.levitation", false, this.playerProperties.levitationTime);
            }
            if (this.playerProperties.hasLevitation && this.playerProperties.isInWater && this.config.badThings.showLevitation) {
                value = (String)value + "-\u00a7m" + Calculations.emojiOrText("text.onebar.levitationEmoji", "text.onebar.levitation", false, this.playerProperties.levitationTime + "\u00a7r");
            }
            if (this.playerProperties.levitationFallHurts && this.config.badThings.showFallHeight && this.config.badThings.showLevitation) {
                value = (String)value + Calculations.emojiOrText("text.onebar.fallingEmoji", "text.onebar.falling", false, this.playerProperties.levitationFallHeight);
            }
            if (this.playerProperties.normalFallHurts && this.config.badThings.showFallHeight && !this.playerProperties.hasLevitation) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.fallingEmoji", "text.onebar.falling", false, this.playerProperties.normalFallHeightDisplay);
            }
            if (this.playerProperties.hasGlowing && this.config.badThings.showGlowing) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.glowingEmoji", "text.onebar.glowing", false, new Object[]{null});
            }
            if (this.playerProperties.hasInfested && this.config.badThings.showInfested) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.infestedEmoji", "text.onebar.infested", false, new Object[]{null});
            }
            if (this.playerProperties.hasWeaving && this.config.badThings.showPostDeathEffects) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.weavingEmoji", "text.onebar.weaving", false, new Object[]{null});
            }
            if (this.playerProperties.hasOozing && this.config.badThings.showPostDeathEffects) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.oozingEmoji", "text.onebar.oozing", false, new Object[]{null});
            }
            if (this.playerProperties.hasWindCharged && this.config.badThings.showPostDeathEffects) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.windChargedEmoji", "text.onebar.windCharged", false, new Object[]{null});
            }
            if (this.playerProperties.hasBadOmen && this.config.badThings.showOmens) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.badOmenEmoji", "text.onebar.badOmen", false, this.playerProperties.badOmenLevel);
            }
            if (this.playerProperties.hasRaidOmen && this.config.badThings.showOmens) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.raidOmenEmoji", "text.onebar.raidOmen", false, this.playerProperties.raidOmenWaves);
            }
            if (this.playerProperties.hasTrialOmen && this.config.badThings.showOmens) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.trialOmenEmoji", "text.onebar.trialOmen", false, this.playerProperties.trialOmenMinutes);
            }
            if (this.playerProperties.isVisibleOnLocatorBar && this.config.otherBars.showLocatability) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.locatorEmoji", "text.onebar.locator", false, new Object[]{null});
            }
            if (this.clientProperties.isHardcore) {
                value = (String)value + "-" + Calculations.emojiOrText("text.onebar.hardcoreEmoji", "text.onebar.hardcore", false, new Object[]{null});
            }
            if (this.hasHunger || this.playerProperties.hasHungerEffect && this.config.healthEstimates && !this.config.disableHunger) {
                value = (String)value + "-";
            }
            if (showHungerParentheses) {
                value = (String)value + "(";
            }
            if (this.hasHunger || this.playerProperties.hasHungerEffect && this.config.healthEstimates && !this.config.disableHunger) {
                value = (String)value + Calculations.emojiOrText("text.onebar.hungerEmoji", "text.onebar.hunger", true, Calculations.makeFraction(this.playerProperties.hunger, false));
            }
            if (this.hasHunger && this.playerProperties.saturation < 1 && this.config.badThings.showHungerDecreasing) {
                value = (String)value + class_2561.method_43471((String)"text.onebar.gettingHungrierEmoji").getString();
            }
            if (this.playerProperties.hasHungerEffect && !this.config.disableHunger && this.config.healthEstimates) {
                value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.hungerEffectEstimate, this.config.textSettings.estimatesItalic);
            }
            if (this.hasHunger && this.playerProperties.isHoldingFood && this.config.goodThings.heldFoodHungerBar) {
                value = (String)value + arrowRight + Calculations.makeFraction(this.playerProperties.heldFoodHungerEstimate, this.config.textSettings.estimatesItalic);
            }
            if (showHungerParentheses) {
                value = (String)value + ")";
            }
        }
        int textX = this.clientProperties.baseEndW - this.client.field_1772.method_1727((String)value);
        int textY = this.clientProperties.baseStartH + 1;
        this.drawContext.method_51433(this.textRenderer, (String)value, textX, textY, this.config.textSettings.textColor, false);
    }

    private void xpBar() {
        int relativeEndW = Calculations.relativeW(this.clientProperties.xpStartW, this.clientProperties.xpEndW, this.playerProperties.xp, this.playerProperties.maxXp);
        int textX = this.clientProperties.xpStartW + 9;
        int textY = this.clientProperties.xpStartH - 10;
        Object lapisText = "";
        if (this.config.otherBars.lapisCounter) {
            if (this.config.otherBars.lapisTimesEnchantable) {
                lapisText = Calculations.getSubscriptNumber(this.playerProperties.lapisLazuliMax) + "\u2093";
                if (this.config.otherBars.adaptiveXpBar && this.playerProperties.lapisLazuliMax < 1) {
                    lapisText = "";
                }
            } else {
                lapisText = Calculations.getSubscriptNumber(this.playerProperties.lapisLazuli);
                if (this.config.otherBars.adaptiveXpBar && this.playerProperties.lapisLazuli < 1) {
                    lapisText = "";
                }
            }
        }
        if (!this.config.otherBars.adaptiveXpBar || this.playerProperties.xpLevel > 0) {
            int sizeLimit = (Boolean)this.client.field_1690.method_42437().method_41753() == false ? 10000 : 1000000;
            int edgeAlignedConst = 13;
            if (this.playerProperties.xpLevel >= 0 && this.playerProperties.xpLevel < sizeLimit) {
                this.drawContext.method_25300(this.textRenderer, String.valueOf(this.playerProperties.xpLevel), textX, textY, this.config.otherBars.xpColor);
            } else if (this.playerProperties.xpLevel >= sizeLimit) {
                if (this.client.field_1690.method_42552().method_41753() == class_1306.field_6183) {
                    this.drawContext.method_25303(this.textRenderer, String.valueOf(this.playerProperties.xpLevel), textX - edgeAlignedConst, textY, this.config.otherBars.xpColor);
                } else if (this.client.field_1690.method_42552().method_41753() == class_1306.field_6182) {
                    this.drawContext.method_25303(this.textRenderer, String.valueOf(this.playerProperties.xpLevel), textX + edgeAlignedConst - this.client.field_1772.method_1727(String.valueOf(this.playerProperties.xpLevel)), textY, this.config.otherBars.xpColor);
                }
            }
            int lapisTextX = this.clientProperties.xpEndW + 1;
            int lapisTextY = this.clientProperties.xpStartH - 5;
            int mendingTextY = textY - 8;
            if (this.client.field_1690.method_42552().method_41753() == class_1306.field_6182) {
                lapisTextX = this.clientProperties.xpStartW - 1 - this.client.field_1772.method_1727((String)lapisText);
            }
            if (this.config.otherBars.lapisCounter) {
                this.drawContext.method_25303(this.textRenderer, (String)lapisText, lapisTextX, lapisTextY, this.config.otherBars.lapisColor);
            }
            if (this.config.otherBars.mendingIndicator && this.playerProperties.isMendingAnything) {
                this.drawContext.method_25300(this.textRenderer, Calculations.emojiOrText("text.onebar.mendingEmoji", "text.onebar.mending", false, new Object[0]), textX, mendingTextY, this.config.otherBars.mendingColor);
            }
        }
        if (!this.config.otherBars.adaptiveXpBar || this.playerProperties.xp > 0) {
            this.renderBar(this.clientProperties.xpStartW, this.clientProperties.xpStartH, this.clientProperties.xpEndW, this.clientProperties.xpEndH, this.config.backgroundColor);
            this.renderBar(this.clientProperties.xpStartW, this.clientProperties.xpStartH, relativeEndW, this.clientProperties.xpEndH, this.config.otherBars.xpColor);
        }
    }

    public void mountJumpBar() {
        if (this.client.field_1724 == null) {
            return;
        }
        class_1297 entity = this.client.field_1724.method_49694();
        if (entity == null) {
            return;
        }
        if (entity instanceof class_7689) {
            this.camelJumpBar();
        } else {
            this.horseJumpBar();
        }
    }

    public void horseJumpBar() {
        if (this.client.field_1724 == null || this.client.field_1724.method_45773() == null) {
            return;
        }
        int barHeight = Calculations.getPreciseInt(1.0f);
        int jumpHeight = Calculations.getPreciseInt(this.client.field_1724.method_3151());
        double heightInBlocks = Math.max(0.0, (double)this.client.field_1724.method_3151() * Calculations.horseJumpStrengthToJumpHeight(this.client.field_1724.method_3151()));
        String roundedHeightInBlocks = Calculations.getSubscriptNumber(Double.parseDouble(String.format(Locale.US, "%,.1f", heightInBlocks)));
        int relativeStartH = Calculations.relativeW(this.clientProperties.horseJumpEndH, this.clientProperties.horseJumpStartH, jumpHeight, barHeight);
        this.renderBar(this.clientProperties.horseJumpStartW, this.clientProperties.horseJumpStartH, this.clientProperties.horseJumpEndW, this.clientProperties.horseJumpEndH, this.config.backgroundColor);
        this.renderBar(this.clientProperties.horseJumpStartW, relativeStartH, this.clientProperties.horseJumpEndW, this.clientProperties.horseJumpEndH, this.config.entity.jumpColor);
        int textX = this.clientProperties.horseJumpEndW - this.client.field_1772.method_1727(roundedHeightInBlocks);
        int textY = this.clientProperties.horseJumpEndH - 10;
        if (this.config.textSettings.showText && this.config.entity.showMountJumpText) {
            this.drawContext.method_51433(this.textRenderer, roundedHeightInBlocks, textX, textY, this.config.textSettings.textColor, false);
        }
    }

    public void camelJumpBar() {
        if (this.client.field_1724 == null || this.client.field_1724.method_45773() == null) {
            return;
        }
        int jumpStrength = Calculations.getPreciseInt(Math.max(this.client.field_1724.method_3151(), 0.0f));
        int maxStrength = Calculations.getPreciseInt(1.0f);
        int cooldown = this.client.field_1724.method_45773().method_45327();
        int maxCooldown = 50;
        int cooldownVisible = cooldown / 20;
        int relativeEndW = this.clientProperties.camelRelativeEndW(jumpStrength, maxStrength);
        int relativeEndWCooldown = this.clientProperties.camelRelativeEndW(cooldown, maxCooldown);
        if (relativeEndWCooldown > relativeEndW) {
            this.camelCooldownBar(relativeEndWCooldown, cooldownVisible);
        } else {
            this.renderBar(this.clientProperties.camelJumpStartW, this.clientProperties.camelJumpStartH, this.clientProperties.camelJumpEndW, this.clientProperties.camelJumpEndH, this.config.backgroundColor);
            this.renderBar(this.clientProperties.camelJumpStartW, this.clientProperties.camelJumpStartH, relativeEndW, this.clientProperties.camelJumpEndH, this.config.entity.jumpColor);
        }
    }

    private void camelCooldownBar(int relativeEndW, int cooldownTimer) {
        if (this.config.entity.showMountCooldown) {
            this.renderBar(this.clientProperties.camelJumpStartW, this.clientProperties.camelJumpStartH, this.clientProperties.camelJumpEndW, this.clientProperties.camelJumpEndH, this.config.backgroundColor);
            this.renderBar(this.clientProperties.camelJumpStartW, this.clientProperties.camelJumpStartH, relativeEndW, this.clientProperties.camelJumpEndH, this.config.entity.cooldownColor);
            if (this.config.textSettings.showText && this.config.entity.showMountCooldownText) {
                String text = Calculations.getSubscriptNumber(-1 - cooldownTimer);
                int textX = this.clientProperties.camelJumpEndW - this.client.field_1772.method_1727(text);
                int textY = this.clientProperties.camelJumpEndH - 9;
                this.drawContext.method_51433(this.textRenderer, text, textX, textY, this.config.textSettings.textColor, false);
            }
        }
    }

    public static int getProtectionFromArmor(class_1799 armorItem) {
        class_9285 attributeModifierComponent = (class_9285)armorItem.method_58694(class_9334.field_49636);
        if (attributeModifierComponent == null) {
            return 0;
        }
        class_5321 ARMOR = (class_5321)class_5134.field_23724.method_40230().get();
        return attributeModifierComponent.comp_2393().stream().filter(entry -> entry.comp_2395().method_40225(ARMOR)).mapToInt(entry -> (int)entry.comp_2396().comp_2449()).findFirst().orElse(0);
    }

    public void mountBar(class_1309 mountEntity) {
        if (mountEntity == null) {
            return;
        }
        float mountRawHealth = mountEntity.method_6032();
        float mountMaxHealth = mountEntity.method_6063();
        int health = (int)Math.ceil(mountRawHealth);
        int horseArmor = mountEntity.method_6096();
        int horseMaxArmor = OneBarElements.getProtectionFromArmor(new class_1799((class_1935)class_1802.field_8807));
        String value = Calculations.emojiOrText("text.onebar.mountHealthEmoji", "text.onebar.mountHealth", true, this.config.textSettings.rawHealth ? Double.valueOf((double)Math.round((double)mountRawHealth * 100.0) / 100.0) : Calculations.makeFraction(health, false));
        int textX = this.clientProperties.baseEndW - this.client.field_1772.method_1727(value);
        int textY = this.clientProperties.mountStartH + 1;
        this.renderBar(this.clientProperties.baseStartW, this.clientProperties.mountStartH, this.clientProperties.baseEndW, this.clientProperties.mountEndH, this.config.backgroundColor);
        this.renderBar(this.clientProperties.baseStartW, this.clientProperties.mountStartH, this.clientProperties.baseRelativeEndW(Calculations.getPreciseInt(mountRawHealth), Calculations.getPreciseInt(mountMaxHealth)), this.clientProperties.mountEndH, this.config.entity.healthColor);
        if (this.config.armor.showArmorBar) {
            this.renderBar(this.clientProperties.baseStartW, this.clientProperties.mountStartH - 1, this.clientProperties.baseRelativeEndW(horseArmor, horseMaxArmor), this.clientProperties.mountStartH, this.config.armor.armorColor);
        }
        if (this.config.textSettings.showText) {
            this.drawContext.method_51433(this.textRenderer, value, textX, textY, this.config.textSettings.textColor, false);
        }
        if (mountEntity instanceof class_7689) {
            long standingUpMax = 52L;
            long standingUpTimer = Math.min(standingUpMax, ((class_7689)mountEntity).method_45355());
            int standingUpTimerVisible = Math.round((float)(standingUpMax - standingUpTimer) / 20.0f);
            if (((class_7689)mountEntity).method_45351()) {
                this.camelCooldownBar(this.clientProperties.camelRelativeEndW(standingUpMax - standingUpTimer, standingUpMax), standingUpTimerVisible);
            }
        }
    }

    private void debugText(String value) {
        this.drawContext.method_25303(this.textRenderer, value, this.clientProperties.baseEndW + 15, this.clientProperties.baseStartH + 1, this.config.textSettings.textColor);
    }
}

