/*
 * Decompiled with CFR 0.152.
 */
package io.github.madis0;

import com.google.common.base.Predicates;
import io.github.madis0.Calculations;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_10707;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1718;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_465;
import net.minecraft.class_486;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_6880;
import net.minecraft.class_7253;
import net.minecraft.class_7260;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class PlayerProperties {
    class_1267 difficulty;
    public static boolean isCreativeOrSpectator = false;
    public final boolean hasResistance;
    public final boolean hasRegeneration;
    public final boolean hasPoison;
    public final boolean hasWither;
    public final boolean hasFireResistance;
    public final boolean hasWaterBreathing;
    public final boolean hasHungerEffect;
    public final boolean hasBadOmen;
    public final boolean hasRaidOmen;
    public final boolean hasTrialOmen;
    public final boolean hasInvisibility;
    public final boolean hasGlowing;
    public final boolean hasWeaving;
    public final boolean hasOozing;
    public final boolean hasWindCharged;
    public final boolean hasInfested;
    public final float healthRaw;
    public final int health;
    public final float maxHealthRaw;
    public final int maxHealth;
    public final int absorption;
    public final boolean hasAbsorption;
    public final int maxArmor;
    public final int armor;
    public int rawMaxArmorDurability;
    public int rawArmorDurability;
    public final float maxArmorDurability;
    public final float armorDurability;
    public int helmetArmor;
    public int helmetMaxArmor;
    public float helmetMaxDurability;
    public int chestplateArmor;
    public int chestplateMaxArmor;
    public float chestplateMaxDurability;
    public int leggingsArmor;
    public int leggingsMaxArmor;
    public float leggingsMaxDurability;
    public int bootsArmor;
    public int bootsMaxArmor;
    public float bootsMaxDurability;
    public boolean hasAnyArmorItem;
    public boolean hasTotemOfUndying;
    public int amountTotemOfUndying;
    public boolean isHoldingTotemOfUndying;
    public boolean hasArrowsStuck;
    public static boolean locatorBarAvailable;
    public boolean isVisibleOnLocatorBar;
    public boolean hasElytra;
    public final boolean isFlyingWithElytra;
    public int elytraDurability;
    public int elytraMaxDurability;
    public boolean isMendingAnything;
    public boolean usesShield;
    public int shieldDurability;
    public int shieldMaxDurability;
    public float shieldAxedCooldown;
    public float shieldAxedMaxCooldown;
    public float shieldRaiseTicksRemaining;
    public float shieldMaxRaiseTicks;
    public final int maxFoodLevel;
    public final float maxFoodLevelRaw;
    public final int foodLevel;
    public final int hunger;
    public final float hungerRaw;
    public final boolean hasHunger;
    public final boolean isStarving;
    public final float saturationRaw;
    public final int saturation;
    public float extraRegenFoodLevel;
    public final int saturationLoss;
    public final boolean hasSaturation;
    public final int maxAirRaw;
    public final int airRaw;
    public final int air;
    public final boolean isInWater;
    public final boolean isUnderwater;
    public final boolean isDrowning;
    public final boolean isSuffocating;
    public final boolean isBurning;
    public final boolean isBurningOnFire;
    public static boolean isBurningOnSoulFire;
    public int burningMultiplier;
    public final int maxFreezeRaw;
    public final int freezeRaw;
    public final int freeze;
    public final boolean isFreezing;
    public final boolean isGettingFreezeDamage;
    public int maxLevitationTimeRaw;
    public final int levitationTimeRaw;
    public final int maxLevitationTime;
    public final int levitationTime;
    public double levitationResultYRaw;
    public double levitationFallHeightRaw;
    public int levitationFallHeight;
    public boolean levitationFallHurts;
    public int levitationFallHealthEstimate;
    public double belowBlockYRaw;
    public int belowBlockY;
    public double normalFallHeightRaw;
    public String normalFallHeightDisplay;
    public boolean normalFallHurts;
    public int normalFallHealthEstimate;
    public final boolean hasLevitation;
    public int resistancePercent;
    public float regenerationHealthRaw;
    public int regenerationHealth;
    public float poisonHealthRaw;
    public int poisonHealth;
    public float witherHealthRaw;
    public int witherHealth;
    public float hungerEffectSaturationLoss;
    public int hungerEffectEstimate;
    public float hungerEffectEstimateRaw;
    public float previousHungerEffectEstimate;
    public int starvationHealthEstimate;
    public int badOmenLevel;
    public int raidOmenWaves;
    public String trialOmenMinutes;
    public float naturalRegenerationAddition;
    public float naturalRegenerationHealthRaw;
    public int naturalRegenerationHealth;
    public float previousNaturalRegenerationHealth;
    public final int xpLevel;
    public final int maxXp;
    public final int xp;
    public int lapisLazuli;
    public int lapisLazuliMax;
    public boolean isHoldingFood;
    public int heldFoodHunger;
    public int heldFoodHungerEstimate;
    public float heldFoodSaturation;
    public float heldFoodSaturationEstimateRaw;
    public float heldFoodHealthEstimateRaw;
    public int heldFoodHealthEstimate;
    public boolean isWardenNear;
    public boolean isWardenAngry;
    public int wardenDanger;
    public int maxWardenDanger;
    public int rawWardenDanger;
    public int rawMaxWardenDanger;

    public PlayerProperties() {
        class_1304[] playerArmorSlots;
        class_746 playerEntity = class_310.method_1551().field_1724;
        class_1702 hungerManager = ((class_1657)Objects.requireNonNull(playerEntity)).method_7344();
        this.difficulty = playerEntity.method_73183().method_8407();
        isCreativeOrSpectator = playerEntity.method_68878() || playerEntity.method_7325();
        this.hasResistance = playerEntity.method_6059(class_1294.field_5907);
        this.hasRegeneration = playerEntity.method_6059(class_1294.field_5924);
        this.hasPoison = playerEntity.method_6059(class_1294.field_5899);
        this.hasWither = playerEntity.method_6059(class_1294.field_5920);
        this.hasFireResistance = playerEntity.method_6059(class_1294.field_5918);
        this.hasWaterBreathing = playerEntity.method_6059(class_1294.field_5923) || playerEntity.method_6059(class_1294.field_5927);
        this.hasHungerEffect = playerEntity.method_6059(class_1294.field_5903) && !this.difficulty.equals((Object)class_1267.field_5801);
        this.hasBadOmen = playerEntity.method_6059(class_1294.field_16595) && !this.difficulty.equals((Object)class_1267.field_5801);
        this.hasRaidOmen = playerEntity.method_6059(class_1294.field_50117) && !this.difficulty.equals((Object)class_1267.field_5801);
        this.hasTrialOmen = playerEntity.method_6059(class_1294.field_50116) && !this.difficulty.equals((Object)class_1267.field_5801);
        this.hasInvisibility = playerEntity.method_6059(class_1294.field_5905);
        this.hasGlowing = playerEntity.method_6059(class_1294.field_5912);
        this.hasWeaving = playerEntity.method_6059(class_1294.field_50119);
        this.hasOozing = playerEntity.method_6059(class_1294.field_50120);
        this.hasWindCharged = playerEntity.method_6059(class_1294.field_50118);
        this.hasInfested = playerEntity.method_6059(class_1294.field_50121);
        this.hasLevitation = playerEntity.method_6059(class_1294.field_5902);
        this.healthRaw = playerEntity.method_6032();
        this.maxHealthRaw = playerEntity.method_6063();
        this.health = class_3532.method_15386((float)this.healthRaw);
        this.maxHealth = class_3532.method_15386((float)this.maxHealthRaw);
        this.absorption = class_3532.method_15386((float)playerEntity.method_6067());
        this.hasAbsorption = this.absorption > 0;
        Objects.requireNonNull(playerEntity);
        this.maxArmor = 20;
        this.armor = playerEntity.method_6096();
        for (class_1304 slot2 : playerArmorSlots = (class_1304[])Arrays.stream(class_1304.values()).filter(slot -> slot.method_5925() == class_1304.class_1305.field_6178).toArray(class_1304[]::new)) {
            class_1799 armorStack = playerEntity.method_6118(slot2);
            if (!armorStack.method_7960() && !armorStack.method_31574(class_1802.field_8833)) {
                this.rawArmorDurability += armorStack.method_7936() - armorStack.method_7919();
                this.rawMaxArmorDurability += armorStack.method_7936();
                continue;
            }
            if (!armorStack.method_31574(class_1802.field_8833)) continue;
            this.hasElytra = true;
            this.elytraDurability = armorStack.method_7936() - armorStack.method_7919();
            this.elytraMaxDurability = armorStack.method_7936();
        }
        class_1799 shieldStack = playerEntity.method_6047().method_31574(class_1802.field_8255) ? playerEntity.method_6047() : (playerEntity.method_6079().method_31574(class_1802.field_8255) ? playerEntity.method_6079() : class_1799.field_8037);
        boolean hasShield = !shieldStack.method_7960();
        this.shieldMaxDurability = hasShield ? shieldStack.method_7936() : 0;
        this.shieldDurability = hasShield ? this.shieldMaxDurability - shieldStack.method_7919() : 0;
        this.usesShield = hasShield && playerEntity.method_6039();
        this.shieldAxedCooldown = hasShield ? playerEntity.method_7357().method_7905(shieldStack, 0.0f) : 0.0f;
        this.shieldAxedMaxCooldown = 1.0f;
        this.shieldMaxRaiseTicks = hasShield ? (float)Objects.requireNonNull((class_10707)shieldStack.method_58694(class_9334.field_56396)).method_67197() : 0.0f;
        this.shieldRaiseTicksRemaining = hasShield && playerEntity.method_6115() && playerEntity.method_6030() == shieldStack ? Math.max(0.0f, this.shieldMaxRaiseTicks - (float)(shieldStack.method_7935((class_1309)playerEntity) - playerEntity.method_6014())) : 0.0f;
        this.maxArmorDurability = this.armor;
        this.armorDurability = this.rawArmorDurability > 0 ? (float)this.rawArmorDurability / (float)this.rawMaxArmorDurability * this.maxArmorDurability : 0.0f;
        this.helmetArmor = this.getArmorElementArmor((class_1657)playerEntity, class_1304.field_6169);
        this.helmetMaxArmor = this.getArmorItemMaxArmor(class_1802.field_22027);
        this.helmetMaxDurability = this.getArmorElementMaxDurability((class_1657)playerEntity, class_1304.field_6169);
        this.chestplateArmor = this.getArmorElementArmor((class_1657)playerEntity, class_1304.field_6174);
        this.chestplateMaxArmor = this.getArmorItemMaxArmor(class_1802.field_22028);
        this.chestplateMaxDurability = this.getArmorElementMaxDurability((class_1657)playerEntity, class_1304.field_6174);
        this.leggingsArmor = this.getArmorElementArmor((class_1657)playerEntity, class_1304.field_6172);
        this.leggingsMaxArmor = this.getArmorItemMaxArmor(class_1802.field_22029);
        this.leggingsMaxDurability = this.getArmorElementMaxDurability((class_1657)playerEntity, class_1304.field_6172);
        this.bootsArmor = this.getArmorElementArmor((class_1657)playerEntity, class_1304.field_6166);
        this.bootsMaxArmor = this.getArmorItemMaxArmor(class_1802.field_22030);
        this.bootsMaxDurability = this.getArmorElementMaxDurability((class_1657)playerEntity, class_1304.field_6166);
        this.hasAnyArmorItem = playerEntity.method_6118(class_1304.field_6169).method_7909() != class_1802.field_8162 || playerEntity.method_6118(class_1304.field_6174).method_7909() != class_1802.field_8162 || playerEntity.method_6118(class_1304.field_6172).method_7909() != class_1802.field_8162 || playerEntity.method_6118(class_1304.field_6166).method_7909() != class_1802.field_8162 || playerEntity.method_6118(class_1304.field_6171).method_7909() != class_1802.field_8162;
        this.amountTotemOfUndying = playerEntity.method_31548().method_18861(class_1802.field_8288);
        this.hasTotemOfUndying = this.amountTotemOfUndying > 0;
        this.isHoldingTotemOfUndying = playerEntity.method_6047().method_31574(class_1802.field_8288) || playerEntity.method_6079().method_31574(class_1802.field_8288);
        this.hasArrowsStuck = playerEntity.method_6022() > 0;
        this.isVisibleOnLocatorBar = locatorBarAvailable && !playerEntity.method_5715() && !this.hasInvisibility && !Set.of(class_1802.field_8681, class_1802.field_8712, class_1802.field_41304, class_1802.field_8575, class_1802.field_8398, class_1802.field_8791, class_1802.field_8470, class_1802.field_17519).contains(playerEntity.method_6118(class_1304.field_6169).method_7909());
        this.isFlyingWithElytra = playerEntity.method_6128();
        class_6880 mendingEntry = (class_6880)playerEntity.method_73183().method_30349().method_30530(class_7924.field_41265).method_10223(class_2960.method_60656((String)"mending")).orElseThrow();
        this.isMendingAnything = Stream.concat(Stream.of(playerEntity.method_6047(), playerEntity.method_6079()), Arrays.stream(playerArmorSlots).map(arg_0 -> ((class_1657)playerEntity).method_6118(arg_0))).anyMatch(stack -> class_1890.method_8225((class_6880)mendingEntry, (class_1799)stack) > 0 && stack.method_7986());
        Objects.requireNonNull(playerEntity);
        this.maxFoodLevel = 20;
        this.maxFoodLevelRaw = this.maxFoodLevel;
        this.foodLevel = hungerManager.method_7586();
        this.hunger = this.maxFoodLevel - this.foodLevel;
        this.hungerRaw = this.hunger;
        this.hasHunger = this.hunger > 0;
        this.isStarving = this.hunger >= this.maxFoodLevel;
        this.saturationRaw = hungerManager.method_7589();
        this.saturation = class_3532.method_15386((float)this.saturationRaw);
        this.extraRegenFoodLevel = this.hunger < 3 ? (float)this.hunger : 0.0f;
        this.saturationLoss = this.maxFoodLevel - this.saturation;
        this.hasSaturation = this.saturationRaw > 0.0f;
        this.maxAirRaw = playerEntity.method_5748();
        this.airRaw = this.maxAirRaw - playerEntity.method_5669();
        int n = Math.min(this.airRaw, this.maxAirRaw);
        Objects.requireNonNull(playerEntity);
        this.air = n / (int)Calculations.getPrettyDivisor(this.maxAirRaw, 20);
        this.isInWater = playerEntity.method_5799();
        this.isUnderwater = playerEntity.method_5869() || this.airRaw > 0;
        this.isDrowning = this.airRaw >= this.maxAirRaw;
        this.isSuffocating = playerEntity.method_5757();
        this.isBurning = playerEntity.method_5862();
        int currentFireTicks = playerEntity.method_20802();
        boolean NO_FIRE_TICKS = false;
        int BURNING_FIRE_TICKS = 160;
        int IN_LAVA_FIRE_TICKS = 300;
        if (currentFireTicks != 160) {
            isBurningOnSoulFire = false;
        }
        if (currentFireTicks == 0 && this.isBurning) {
            this.burningMultiplier = 1;
        } else if (currentFireTicks == 160) {
            this.burningMultiplier = isBurningOnSoulFire ? 3 : 2;
        } else if (currentFireTicks == 300) {
            this.burningMultiplier = 4;
        }
        this.isBurningOnFire = this.isBurning && !this.hasFireResistance;
        this.maxFreezeRaw = playerEntity.method_32315();
        this.freezeRaw = playerEntity.method_32312();
        Objects.requireNonNull(playerEntity);
        this.freeze = this.freezeRaw / (int)Calculations.getPrettyDivisor(this.maxFreezeRaw, 20);
        this.isFreezing = this.freezeRaw > 0;
        this.isGettingFreezeDamage = playerEntity.method_32314() && !this.difficulty.equals((Object)class_1267.field_5801);
        this.maxLevitationTimeRaw = 200;
        this.levitationTimeRaw = this.hasLevitation ? Math.max(Objects.requireNonNull(playerEntity.method_6112(class_1294.field_5902)).method_5584(), 0) : 0;
        this.maxLevitationTime = this.maxLevitationTimeRaw / 20;
        this.levitationTime = this.levitationTimeRaw / (int)Calculations.getPrettyDivisor(this.maxLevitationTimeRaw, this.maxLevitationTime);
        this.belowBlockYRaw = playerEntity.method_23318();
        double y = (int)playerEntity.method_23318();
        double voidLimit = -128.0;
        if (playerEntity.method_73183() != null && (!playerEntity.method_24828() || playerEntity.method_5715())) {
            class_2680 state;
            class_1937 world = playerEntity.method_73183();
            int x = (int)playerEntity.method_23317();
            int z = (int)playerEntity.method_23321();
            while ((state = world.method_8320(new class_2338(x, (int)(y -= 1.0), z))).method_26215() && y >= voidLimit) {
                this.belowBlockYRaw = y;
            }
        }
        this.belowBlockY = (int)Math.round(this.belowBlockYRaw);
        if (playerEntity.method_6059(class_1294.field_5902)) {
            class_1293 effect = playerEntity.method_6112(class_1294.field_5902);
            double estHeight = (double)(Objects.requireNonNull(effect).method_5578() + 1) * 0.9 * (double)((float)effect.method_5584() / 20.0f);
            this.levitationResultYRaw = playerEntity.method_23318() + estHeight;
            this.levitationFallHeightRaw = this.getFallingHeightEstimate((class_1657)playerEntity, this.levitationResultYRaw - this.belowBlockYRaw);
            this.levitationFallHeight = (int)Math.round(this.levitationFallHeightRaw);
            this.levitationFallHurts = this.levitationFallHeight > 3;
            this.levitationFallHealthEstimate = this.getFallingHealthEstimate(this.healthRaw, this.levitationFallHeight, this.levitationFallHurts);
        }
        this.normalFallHeightRaw = this.getFallingHeightEstimate((class_1657)playerEntity, playerEntity.method_23318() - this.belowBlockYRaw);
        this.normalFallHurts = this.normalFallHeightRaw > 3.0;
        this.normalFallHealthEstimate = this.getFallingHealthEstimate(this.healthRaw, this.normalFallHeightRaw, this.normalFallHurts);
        this.normalFallHeightDisplay = new DecimalFormat("0.#").format(this.normalFallHeightRaw);
        this.badOmenLevel = this.hasBadOmen ? Objects.requireNonNull(playerEntity.method_6112(class_1294.field_16595)).method_5578() + 1 : 0;
        this.raidOmenWaves = this.calculateRaidWaves((class_1657)playerEntity);
        this.trialOmenMinutes = this.getTrialOmenTimeString((class_1657)playerEntity);
        this.xpLevel = playerEntity.field_7520;
        this.maxXp = 183;
        this.xp = (int)(playerEntity.field_7510 * (float)this.maxXp);
        this.lapisLazuli = playerEntity.method_31548().method_18861(class_1802.field_8759) + playerEntity.method_31548().method_18861(class_1802.field_8055) * 9;
        class_310 client = class_310.method_1551();
        if (client.field_1755 instanceof class_486) {
            this.lapisLazuli += ((class_1718)((class_486)client.field_1755).method_17577()).method_7638();
        }
        if (client.field_1755 instanceof class_465) {
            class_1799 pickedUpItemInInventory = ((class_465)client.field_1755).method_17577().method_34255();
            if (pickedUpItemInInventory.method_31574(class_1802.field_8055)) {
                this.lapisLazuli += pickedUpItemInInventory.method_7947() * 9;
            }
            if (pickedUpItemInInventory.method_31574(class_1802.field_8759)) {
                this.lapisLazuli += pickedUpItemInInventory.method_7947();
            }
            if (pickedUpItemInInventory.method_31574(class_1802.field_8288)) {
                this.amountTotemOfUndying += pickedUpItemInInventory.method_7947();
            }
        }
        this.lapisLazuliMax = 0;
        int timesCanEnchant = (this.xpLevel - 27) / 3;
        int lapisCanEnchant = this.lapisLazuli / 3;
        if (timesCanEnchant > 0) {
            this.lapisLazuliMax = Math.min(timesCanEnchant, lapisCanEnchant);
        }
        class_1293 resistanceEffect = playerEntity.method_6112(class_1294.field_5907);
        this.resistancePercent = 0;
        if (resistanceEffect != null) {
            this.resistancePercent = (resistanceEffect.method_5578() + 1) * 20;
        }
        class_1293 regenerationEffect = playerEntity.method_6112(class_1294.field_5924);
        this.regenerationHealthRaw = 0.0f;
        if (regenerationEffect != null) {
            this.regenerationHealthRaw = Calculations.getEstimatedHealthRegen(50, regenerationEffect.method_5578(), regenerationEffect.method_5584(), this.healthRaw, this.maxHealthRaw);
        }
        this.regenerationHealth = class_3532.method_15386((float)this.regenerationHealthRaw);
        class_1293 poisonEffect = playerEntity.method_6112(class_1294.field_5899);
        this.poisonHealthRaw = this.maxHealthRaw;
        if (poisonEffect != null) {
            this.poisonHealthRaw = Calculations.getEstimatedHealthDamage(25, poisonEffect.method_5578(), poisonEffect.method_5584(), this.healthRaw, 1.0f);
        }
        this.poisonHealth = class_3532.method_15386((float)this.poisonHealthRaw);
        class_1293 witherEffect = playerEntity.method_6112(class_1294.field_5920);
        this.witherHealthRaw = this.maxHealthRaw;
        if (witherEffect != null) {
            this.witherHealthRaw = Calculations.getEstimatedHealthDamage(40, witherEffect.method_5578(), witherEffect.method_5584(), this.healthRaw, 0.0f);
        }
        this.witherHealth = class_3532.method_15386((float)this.witherHealthRaw);
        class_1293 hungerEffect = playerEntity.method_6112(class_1294.field_5903);
        this.hungerEffectSaturationLoss = 0.0f;
        if (hungerEffect != null) {
            int duration = hungerEffect.method_5584();
            float hungerEffectExhaustionLoss = 0.005f * (float)(hungerEffect.method_5578() + 1) * (float)duration;
            this.hungerEffectSaturationLoss = hungerEffectExhaustionLoss / 4.0f;
            if (class_3532.method_15386((float)(this.hungerRaw + this.hungerEffectSaturationLoss)) != class_3532.method_15386((float)this.previousHungerEffectEstimate) - 1) {
                this.previousHungerEffectEstimate = this.hungerEffectEstimateRaw = !this.hasSaturation ? Math.max(Math.min(this.hungerRaw + this.hungerEffectSaturationLoss, this.maxFoodLevelRaw), 0.0f) : this.hungerRaw;
            }
        } else {
            this.previousHungerEffectEstimate = this.hungerEffectEstimateRaw = this.hungerRaw;
        }
        this.hungerEffectEstimate = class_3532.method_15386((float)this.hungerEffectEstimateRaw);
        if (this.isStarving) {
            if (this.difficulty == class_1267.field_5805) {
                this.starvationHealthEstimate = Math.min(10, this.health);
            } else if (this.difficulty == class_1267.field_5802) {
                this.starvationHealthEstimate = Math.min(1, this.health);
            } else if (this.difficulty == class_1267.field_5807) {
                this.starvationHealthEstimate = 0;
            }
        }
        this.naturalRegenerationAddition = 0.0f;
        if (this.health < this.maxHealth) {
            if (this.hunger < 3 && !this.difficulty.equals((Object)class_1267.field_5801)) {
                this.naturalRegenerationAddition = Calculations.getNaturalRegenAddition(this.saturationRaw, this.hungerRaw);
            } else if (this.difficulty.equals((Object)class_1267.field_5801)) {
                this.naturalRegenerationAddition = this.maxHealthRaw - this.healthRaw;
            }
            if (class_3532.method_15386((float)((float)this.health + this.naturalRegenerationAddition)) != class_3532.method_15386((float)this.previousNaturalRegenerationHealth) + 1) {
                this.naturalRegenerationHealthRaw = Math.min(this.healthRaw + this.naturalRegenerationAddition, this.maxHealthRaw);
                this.previousNaturalRegenerationHealth = this.naturalRegenerationHealth;
            }
        } else {
            this.previousNaturalRegenerationHealth = this.naturalRegenerationHealthRaw = this.healthRaw;
        }
        this.naturalRegenerationHealth = class_3532.method_15386((float)this.naturalRegenerationHealthRaw);
        this.heldFoodHunger = 0;
        class_1799 heldFoodItem = ((class_1657)Objects.requireNonNull(playerEntity)).method_6047();
        if (!heldFoodItem.method_57353().method_57832(class_9334.field_50075)) {
            heldFoodItem = playerEntity.method_6079();
        }
        if (heldFoodItem.method_57353().method_57832(class_9334.field_50075)) {
            this.isHoldingFood = true;
            class_4174 itemFood = (class_4174)heldFoodItem.method_7909().method_57347().method_58694(class_9334.field_50075);
            this.heldFoodHunger = Objects.requireNonNull(itemFood).comp_2491();
            this.heldFoodSaturation = Objects.requireNonNull(itemFood).comp_2492() * (float)this.heldFoodHunger * 2.0f;
        } else {
            this.isHoldingFood = false;
        }
        this.heldFoodHungerEstimate = this.hunger - this.heldFoodHunger;
        if (this.isHoldingFood && this.hasHunger) {
            this.heldFoodHealthEstimateRaw = !this.difficulty.equals((Object)class_1267.field_5801) ? Math.min(this.healthRaw + Calculations.getNaturalRegenAddition(this.saturationRaw + this.extraRegenFoodLevel + this.heldFoodSaturation, this.hungerRaw), this.maxFoodLevelRaw) : this.maxHealthRaw - this.healthRaw;
            this.heldFoodSaturationEstimateRaw = Math.max(this.heldFoodSaturation - (this.maxHealthRaw - this.healthRaw) - this.extraRegenFoodLevel, 0.0f);
        } else {
            this.heldFoodHealthEstimateRaw = 0.0f;
            this.heldFoodSaturationEstimateRaw = 0.0f;
        }
        this.heldFoodHealthEstimate = class_3532.method_15386((float)this.heldFoodHealthEstimateRaw);
        this.rawMaxWardenDanger = 149;
        this.maxWardenDanger = 20;
        this.rawWardenDanger = 0;
        this.wardenDanger = 0;
        this.isWardenNear = false;
        this.isWardenAngry = false;
        class_7260 warden = this.getClosestWarden((class_1657)playerEntity);
        if (warden != null) {
            this.isWardenNear = true;
            this.rawWardenDanger = warden.method_42222();
            this.isWardenAngry = this.rawWardenDanger > class_7253.field_38122.method_42170();
            double d = this.rawWardenDanger;
            Objects.requireNonNull(playerEntity);
            this.wardenDanger = (int)(d / Calculations.getPrettyDivisor(this.rawMaxWardenDanger, 20));
        }
    }

    public static void setPlayerBurningOnSoulFire(boolean isBurning) {
        isBurningOnSoulFire = isBurning;
    }

    public static void setLocatorBarAvailable(boolean isAvailable) {
        locatorBarAvailable = isAvailable;
    }

    private double getFallingHeightEstimate(class_1657 playerEntity, double height) {
        return height;
    }

    private int getFallingHealthEstimate(float health, double height, boolean hurts) {
        double value;
        double d = value = hurts ? (double)health - Math.max(0.0, height - 3.0) : (double)health;
        if (value == 0.0) {
            value = 1.0;
        }
        if (value <= -1.0) {
            value = 0.0;
        }
        return class_3532.method_15384((double)value);
    }

    private class_7260 getClosestWarden(class_1657 player) {
        class_238 boundingBox = player.method_5829().method_1009(49.0, 51.0, 49.0);
        List nearbyWardens = player.method_73183().method_18023(class_5575.method_31795(class_7260.class), boundingBox, (Predicate)Predicates.alwaysTrue());
        return nearbyWardens.stream().min(Comparator.comparingDouble(e -> Calculations.getDistance(player.method_23317(), player.method_23318(), player.method_23321(), e.method_23317(), e.method_23318(), e.method_23321()))).orElse(null);
    }

    public static int getProtectionFromArmor(class_1799 armorItem) {
        class_9285 attributeModifierComponent = (class_9285)armorItem.method_58694(class_9334.field_49636);
        if (attributeModifierComponent == null) {
            return 0;
        }
        class_5321 ARMOR = (class_5321)class_5134.field_23724.method_40230().get();
        return attributeModifierComponent.comp_2393().stream().filter(entry -> entry.comp_2395().method_40225(ARMOR)).mapToInt(entry -> (int)entry.comp_2396().comp_2449()).findFirst().orElse(0);
    }

    private int getArmorElementArmor(class_1657 playerEntity, class_1304 slot) {
        return PlayerProperties.getProtectionFromArmor(playerEntity.method_6118(slot));
    }

    private int getArmorItemMaxArmor(class_1792 armorItem) {
        return PlayerProperties.getProtectionFromArmor(new class_1799((class_1935)armorItem));
    }

    public float getArmorElementDurability(class_1657 playerEntity, class_1304 slot, float maxLimit) {
        class_1799 armorItem = playerEntity.method_6118(slot);
        if (armorItem != class_1799.field_8037) {
            int rawArmorDurability = armorItem.method_7936() - armorItem.method_7919();
            int rawMaxArmorDurability = armorItem.method_7936();
            return rawArmorDurability > 0 ? (float)rawArmorDurability / (float)rawMaxArmorDurability * maxLimit : 0.0f;
        }
        return 0.0f;
    }

    private float getArmorElementMaxDurability(class_1657 playerEntity, class_1304 slot) {
        class_1799 armorItem = playerEntity.method_6118(slot);
        if (armorItem != class_1799.field_8037) {
            return armorItem.method_7936();
        }
        return 0.0f;
    }

    public static String getMobHead(class_1657 playerEntity) {
        boolean hasPiglinDeterArmorItem;
        class_1792 headItem = playerEntity.method_6118(class_1304.field_6169).method_7909();
        boolean bl = hasPiglinDeterArmorItem = playerEntity.method_6118(class_1304.field_6169).method_7909() == class_1802.field_8862 || playerEntity.method_6118(class_1304.field_6174).method_7909() == class_1802.field_8678 || playerEntity.method_6118(class_1304.field_6172).method_7909() == class_1802.field_8416 || playerEntity.method_6118(class_1304.field_6166).method_7909() == class_1802.field_8753;
        if (headItem == class_1802.field_8470) {
            return Calculations.emojiOrText("text.onebar.mobHeadZombieEmoji", "text.onebar.mobHeadZombie", false, PlayerProperties.calculateMobDetectionRange(playerEntity, 35.0));
        }
        if (headItem == class_1802.field_8398) {
            return Calculations.emojiOrText("text.onebar.mobHeadSkeletonEmoji", "text.onebar.mobHeadSkeleton", false, PlayerProperties.calculateMobDetectionRange(playerEntity, 16.0));
        }
        if (headItem == class_1802.field_8681) {
            return Calculations.emojiOrText("text.onebar.mobHeadCreeperEmoji", "text.onebar.mobHeadCreeper", false, PlayerProperties.calculateMobDetectionRange(playerEntity, 16.0));
        }
        if (headItem == class_1802.field_41304 && !hasPiglinDeterArmorItem) {
            return Calculations.emojiOrText("text.onebar.mobHeadPiglinEmoji", "text.onebar.mobHeadPiglin", false, PlayerProperties.calculateMobDetectionRange(playerEntity, 16.0));
        }
        if (hasPiglinDeterArmorItem) {
            return Calculations.emojiOrText("text.onebar.mobHeadPiglinEmoji", "text.onebar.mobHeadPiglin", false, 0);
        }
        if (headItem == class_1802.field_17519) {
            return Calculations.emojiOrText("text.onebar.mobHeadEndermanEmoji", "text.onebar.mobHeadEnderman", false, 0);
        }
        if (locatorBarAvailable && (headItem == class_1802.field_8575 || headItem == class_1802.field_8712 || headItem == class_1802.field_8791)) {
            return Calculations.emojiOrText("text.onebar.mobHeadLocatorEmoji", "text.onebar.mobHeadLocator", false, 0);
        }
        return null;
    }

    private static int calculateMobDetectionRange(class_1657 playerEntity, double baseRange) {
        if (playerEntity.method_73183().method_8407() == class_1267.field_5801) {
            return 0;
        }
        double modifiedRange = baseRange;
        modifiedRange *= 0.5;
        if (playerEntity.method_5715()) {
            modifiedRange *= 0.8;
        }
        if (playerEntity.method_6059(class_1294.field_5905)) {
            double invisFactor;
            int armorPieces = 0;
            if (playerEntity.method_6118(class_1304.field_6169).method_7909() != class_1802.field_8162) {
                ++armorPieces;
            }
            if (playerEntity.method_6118(class_1304.field_6174).method_7909() != class_1802.field_8162) {
                ++armorPieces;
            }
            if (playerEntity.method_6118(class_1304.field_6172).method_7909() != class_1802.field_8162) {
                ++armorPieces;
            }
            if (playerEntity.method_6118(class_1304.field_6166).method_7909() != class_1802.field_8162) {
                ++armorPieces;
            }
            if ((invisFactor = 0.175 * (double)armorPieces) > 1.0) {
                invisFactor = 1.0;
            }
            modifiedRange *= invisFactor;
        }
        return (int)Math.ceil(modifiedRange);
    }

    private int calculateRaidWaves(class_1657 player) {
        int amplifier;
        int baseWaves;
        class_1267 diff = player.method_73183().method_8407();
        switch (diff) {
            default: {
                throw new MatchException(null, null);
            }
            case field_5801: {
                int n = 0;
                break;
            }
            case field_5805: {
                int n = 3;
                break;
            }
            case field_5802: {
                int n = 5;
                break;
            }
            case field_5807: {
                int n = baseWaves = 7;
            }
        }
        if (player.method_6059(class_1294.field_50117) && (amplifier = player.method_6112(class_1294.field_50117).method_5578()) + 1 >= 2) {
            ++baseWaves;
        }
        return baseWaves;
    }

    public String getTrialOmenTimeString(class_1657 player) {
        if (!player.method_6059(class_1294.field_50116)) {
            return "";
        }
        class_1293 trial = player.method_6112(class_1294.field_50116);
        int ticks = trial.method_5584();
        int totalSeconds = ticks / 20;
        if (totalSeconds >= 60) {
            int minutes = totalSeconds / 60;
            return class_2561.method_43469((String)"text.onebar.trialOmenEmoji.minutes", (Object[])new Object[]{minutes}).getString();
        }
        if (totalSeconds >= 30) {
            return class_2561.method_43471((String)"text.onebar.trialOmenEmoji.underMinute").getString();
        }
        return String.valueOf(totalSeconds);
    }
}

